// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The name of the condition for the delivery rule. </summary>
    internal readonly partial struct MatchVariable : IEquatable<MatchVariable>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MatchVariable"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MatchVariable(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RemoteAddressValue = "RemoteAddress";
        private const string RequestMethodValue = "RequestMethod";
        private const string QueryStringValue = "QueryString";
        private const string PostArgsValue = "PostArgs";
        private const string RequestUriValue = "RequestUri";
        private const string RequestHeaderValue = "RequestHeader";
        private const string RequestBodyValue = "RequestBody";
        private const string RequestSchemeValue = "RequestScheme";
        private const string UriPathValue = "UrlPath";
        private const string UriFileExtensionValue = "UrlFileExtension";
        private const string UriFileNameValue = "UrlFileName";
        private const string HttpVersionValue = "HttpVersion";
        private const string CookiesValue = "Cookies";
        private const string IsDeviceValue = "IsDevice";
        private const string SocketAddrValue = "SocketAddr";
        private const string ClientPortValue = "ClientPort";
        private const string ServerPortValue = "ServerPort";
        private const string HostNameValue = "HostName";
        private const string SslProtocolValue = "SslProtocol";

        /// <summary> RemoteAddress. </summary>
        public static MatchVariable RemoteAddress { get; } = new MatchVariable(RemoteAddressValue);
        /// <summary> RequestMethod. </summary>
        public static MatchVariable RequestMethod { get; } = new MatchVariable(RequestMethodValue);
        /// <summary> QueryString. </summary>
        public static MatchVariable QueryString { get; } = new MatchVariable(QueryStringValue);
        /// <summary> PostArgs. </summary>
        public static MatchVariable PostArgs { get; } = new MatchVariable(PostArgsValue);
        /// <summary> RequestUri. </summary>
        public static MatchVariable RequestUri { get; } = new MatchVariable(RequestUriValue);
        /// <summary> RequestHeader. </summary>
        public static MatchVariable RequestHeader { get; } = new MatchVariable(RequestHeaderValue);
        /// <summary> RequestBody. </summary>
        public static MatchVariable RequestBody { get; } = new MatchVariable(RequestBodyValue);
        /// <summary> RequestScheme. </summary>
        public static MatchVariable RequestScheme { get; } = new MatchVariable(RequestSchemeValue);
        /// <summary> UrlPath. </summary>
        public static MatchVariable UriPath { get; } = new MatchVariable(UriPathValue);
        /// <summary> UrlFileExtension. </summary>
        public static MatchVariable UriFileExtension { get; } = new MatchVariable(UriFileExtensionValue);
        /// <summary> UrlFileName. </summary>
        public static MatchVariable UriFileName { get; } = new MatchVariable(UriFileNameValue);
        /// <summary> HttpVersion. </summary>
        public static MatchVariable HttpVersion { get; } = new MatchVariable(HttpVersionValue);
        /// <summary> Cookies. </summary>
        public static MatchVariable Cookies { get; } = new MatchVariable(CookiesValue);
        /// <summary> IsDevice. </summary>
        public static MatchVariable IsDevice { get; } = new MatchVariable(IsDeviceValue);
        /// <summary> SocketAddr. </summary>
        public static MatchVariable SocketAddr { get; } = new MatchVariable(SocketAddrValue);
        /// <summary> ClientPort. </summary>
        public static MatchVariable ClientPort { get; } = new MatchVariable(ClientPortValue);
        /// <summary> ServerPort. </summary>
        public static MatchVariable ServerPort { get; } = new MatchVariable(ServerPortValue);
        /// <summary> HostName. </summary>
        public static MatchVariable HostName { get; } = new MatchVariable(HostNameValue);
        /// <summary> SslProtocol. </summary>
        public static MatchVariable SslProtocol { get; } = new MatchVariable(SslProtocolValue);
        /// <summary> Determines if two <see cref="MatchVariable"/> values are the same. </summary>
        public static bool operator ==(MatchVariable left, MatchVariable right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MatchVariable"/> values are not the same. </summary>
        public static bool operator !=(MatchVariable left, MatchVariable right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MatchVariable"/>. </summary>
        public static implicit operator MatchVariable(string value) => new MatchVariable(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MatchVariable other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MatchVariable other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
