// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The LogMetric. </summary>
    public readonly partial struct LogMetric : IEquatable<LogMetric>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LogMetric"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LogMetric(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClientRequestCountValue = "clientRequestCount";
        private const string ClientRequestTrafficValue = "clientRequestTraffic";
        private const string ClientRequestBandwidthValue = "clientRequestBandwidth";
        private const string OriginRequestTrafficValue = "originRequestTraffic";
        private const string OriginRequestBandwidthValue = "originRequestBandwidth";
        private const string TotalLatencyValue = "totalLatency";

        /// <summary> clientRequestCount. </summary>
        public static LogMetric ClientRequestCount { get; } = new LogMetric(ClientRequestCountValue);
        /// <summary> clientRequestTraffic. </summary>
        public static LogMetric ClientRequestTraffic { get; } = new LogMetric(ClientRequestTrafficValue);
        /// <summary> clientRequestBandwidth. </summary>
        public static LogMetric ClientRequestBandwidth { get; } = new LogMetric(ClientRequestBandwidthValue);
        /// <summary> originRequestTraffic. </summary>
        public static LogMetric OriginRequestTraffic { get; } = new LogMetric(OriginRequestTrafficValue);
        /// <summary> originRequestBandwidth. </summary>
        public static LogMetric OriginRequestBandwidth { get; } = new LogMetric(OriginRequestBandwidthValue);
        /// <summary> totalLatency. </summary>
        public static LogMetric TotalLatency { get; } = new LogMetric(TotalLatencyValue);
        /// <summary> Determines if two <see cref="LogMetric"/> values are the same. </summary>
        public static bool operator ==(LogMetric left, LogMetric right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LogMetric"/> values are not the same. </summary>
        public static bool operator !=(LogMetric left, LogMetric right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LogMetric"/>. </summary>
        public static implicit operator LogMetric(string value) => new LogMetric(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LogMetric other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LogMetric other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
