// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> whether this route will be linked to the default endpoint domain. </summary>
    public readonly partial struct LinkToDefaultDomain : IEquatable<LinkToDefaultDomain>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LinkToDefaultDomain"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LinkToDefaultDomain(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static LinkToDefaultDomain Enabled { get; } = new LinkToDefaultDomain(EnabledValue);
        /// <summary> Disabled. </summary>
        public static LinkToDefaultDomain Disabled { get; } = new LinkToDefaultDomain(DisabledValue);
        /// <summary> Determines if two <see cref="LinkToDefaultDomain"/> values are the same. </summary>
        public static bool operator ==(LinkToDefaultDomain left, LinkToDefaultDomain right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LinkToDefaultDomain"/> values are not the same. </summary>
        public static bool operator !=(LinkToDefaultDomain left, LinkToDefaultDomain right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LinkToDefaultDomain"/>. </summary>
        public static implicit operator LinkToDefaultDomain(string value) => new LinkToDefaultDomain(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LinkToDefaultDomain other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LinkToDefaultDomain other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
