// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The KeyVaultSigningKeyType. </summary>
    public readonly partial struct KeyVaultSigningKeyType : IEquatable<KeyVaultSigningKeyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KeyVaultSigningKeyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KeyVaultSigningKeyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string KeyVaultSigningKeyValue = "KeyVaultSigningKeyParameters";

        /// <summary> KeyVaultSigningKeyParameters. </summary>
        public static KeyVaultSigningKeyType KeyVaultSigningKey { get; } = new KeyVaultSigningKeyType(KeyVaultSigningKeyValue);
        /// <summary> Determines if two <see cref="KeyVaultSigningKeyType"/> values are the same. </summary>
        public static bool operator ==(KeyVaultSigningKeyType left, KeyVaultSigningKeyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KeyVaultSigningKeyType"/> values are not the same. </summary>
        public static bool operator !=(KeyVaultSigningKeyType left, KeyVaultSigningKeyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KeyVaultSigningKeyType"/>. </summary>
        public static implicit operator KeyVaultSigningKeyType(string value) => new KeyVaultSigningKeyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KeyVaultSigningKeyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KeyVaultSigningKeyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
