// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Describes the parameters for using a user's KeyVault for URL Signing Key. </summary>
    public partial class KeyVaultSigningKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KeyVaultSigningKey"/>. </summary>
        /// <param name="keyType"></param>
        /// <param name="subscriptionId"> Subscription Id of the user's Key Vault containing the secret. </param>
        /// <param name="resourceGroupName"> Resource group of the user's Key Vault containing the secret. </param>
        /// <param name="vaultName"> The name of the user's Key Vault containing the secret. </param>
        /// <param name="secretName"> The name of secret in Key Vault. </param>
        /// <param name="secretVersion"> The version(GUID) of secret in Key Vault. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="vaultName"/>, <paramref name="secretName"/> or <paramref name="secretVersion"/> is null. </exception>
        public KeyVaultSigningKey(KeyVaultSigningKeyType keyType, string subscriptionId, string resourceGroupName, string vaultName, string secretName, string secretVersion)
        {
            Argument.AssertNotNull(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNull(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNull(vaultName, nameof(vaultName));
            Argument.AssertNotNull(secretName, nameof(secretName));
            Argument.AssertNotNull(secretVersion, nameof(secretVersion));

            KeyType = keyType;
            SubscriptionId = subscriptionId;
            ResourceGroupName = resourceGroupName;
            VaultName = vaultName;
            SecretName = secretName;
            SecretVersion = secretVersion;
        }

        /// <summary> Initializes a new instance of <see cref="KeyVaultSigningKey"/>. </summary>
        /// <param name="keyType"></param>
        /// <param name="subscriptionId"> Subscription Id of the user's Key Vault containing the secret. </param>
        /// <param name="resourceGroupName"> Resource group of the user's Key Vault containing the secret. </param>
        /// <param name="vaultName"> The name of the user's Key Vault containing the secret. </param>
        /// <param name="secretName"> The name of secret in Key Vault. </param>
        /// <param name="secretVersion"> The version(GUID) of secret in Key Vault. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KeyVaultSigningKey(KeyVaultSigningKeyType keyType, string subscriptionId, string resourceGroupName, string vaultName, string secretName, string secretVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyType = keyType;
            SubscriptionId = subscriptionId;
            ResourceGroupName = resourceGroupName;
            VaultName = vaultName;
            SecretName = secretName;
            SecretVersion = secretVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="KeyVaultSigningKey"/> for deserialization. </summary>
        internal KeyVaultSigningKey()
        {
        }

        /// <summary> Gets or sets the key type. </summary>
        public KeyVaultSigningKeyType KeyType { get; set; }
        /// <summary> Subscription Id of the user's Key Vault containing the secret. </summary>
        public string SubscriptionId { get; set; }
        /// <summary> Resource group of the user's Key Vault containing the secret. </summary>
        public string ResourceGroupName { get; set; }
        /// <summary> The name of the user's Key Vault containing the secret. </summary>
        public string VaultName { get; set; }
        /// <summary> The name of secret in Key Vault. </summary>
        public string SecretName { get; set; }
        /// <summary> The version(GUID) of secret in Key Vault. </summary>
        public string SecretVersion { get; set; }
    }
}
