// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> CDN Ip address group. </summary>
    public partial class IPAddressGroup
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IPAddressGroup"/>. </summary>
        public IPAddressGroup()
        {
            IPv4Addresses = new ChangeTrackingList<CidrIPAddress>();
            IPv6Addresses = new ChangeTrackingList<CidrIPAddress>();
        }

        /// <summary> Initializes a new instance of <see cref="IPAddressGroup"/>. </summary>
        /// <param name="deliveryRegion"> The delivery region of the ip address group. </param>
        /// <param name="ipv4Addresses"> The list of ip v4 addresses. </param>
        /// <param name="ipv6Addresses"> The list of ip v6 addresses. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IPAddressGroup(string deliveryRegion, IList<CidrIPAddress> ipv4Addresses, IList<CidrIPAddress> ipv6Addresses, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeliveryRegion = deliveryRegion;
            IPv4Addresses = ipv4Addresses;
            IPv6Addresses = ipv6Addresses;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The delivery region of the ip address group. </summary>
        public string DeliveryRegion { get; set; }
        /// <summary> The list of ip v4 addresses. </summary>
        public IList<CidrIPAddress> IPv4Addresses { get; }
        /// <summary> The list of ip v6 addresses. </summary>
        public IList<CidrIPAddress> IPv6Addresses { get; }
    }
}
