// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Cdn.Models
{
    public partial class IPAddressGroup : IUtf8JsonSerializable, IJsonModel<IPAddressGroup>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<IPAddressGroup>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<IPAddressGroup>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IPAddressGroup>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IPAddressGroup)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(DeliveryRegion))
            {
                writer.WritePropertyName("deliveryRegion"u8);
                writer.WriteStringValue(DeliveryRegion);
            }
            if (Optional.IsCollectionDefined(IPv4Addresses))
            {
                writer.WritePropertyName("ipv4Addresses"u8);
                writer.WriteStartArray();
                foreach (var item in IPv4Addresses)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IPv6Addresses))
            {
                writer.WritePropertyName("ipv6Addresses"u8);
                writer.WriteStartArray();
                foreach (var item in IPv6Addresses)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        IPAddressGroup IJsonModel<IPAddressGroup>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IPAddressGroup>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IPAddressGroup)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeIPAddressGroup(document.RootElement, options);
        }

        internal static IPAddressGroup DeserializeIPAddressGroup(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string deliveryRegion = default;
            IList<CidrIPAddress> ipv4Addresses = default;
            IList<CidrIPAddress> ipv6Addresses = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("deliveryRegion"u8))
                {
                    deliveryRegion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ipv4Addresses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CidrIPAddress> array = new List<CidrIPAddress>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CidrIPAddress.DeserializeCidrIPAddress(item, options));
                    }
                    ipv4Addresses = array;
                    continue;
                }
                if (property.NameEquals("ipv6Addresses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CidrIPAddress> array = new List<CidrIPAddress>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CidrIPAddress.DeserializeCidrIPAddress(item, options));
                    }
                    ipv6Addresses = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new IPAddressGroup(deliveryRegion, ipv4Addresses ?? new ChangeTrackingList<CidrIPAddress>(), ipv6Addresses ?? new ChangeTrackingList<CidrIPAddress>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<IPAddressGroup>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IPAddressGroup>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(IPAddressGroup)} does not support writing '{options.Format}' format.");
            }
        }

        IPAddressGroup IPersistableModel<IPAddressGroup>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IPAddressGroup>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeIPAddressGroup(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(IPAddressGroup)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<IPAddressGroup>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
