// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Cdn.Models
{
    internal static partial class HealthProbeRequestTypeExtensions
    {
        public static string ToSerialString(this HealthProbeRequestType value) => value switch
        {
            HealthProbeRequestType.NotSet => "NotSet",
            HealthProbeRequestType.Get => "GET",
            HealthProbeRequestType.Head => "HEAD",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthProbeRequestType value.")
        };

        public static HealthProbeRequestType ToHealthProbeRequestType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotSet")) return HealthProbeRequestType.NotSet;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "GET")) return HealthProbeRequestType.Get;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "HEAD")) return HealthProbeRequestType.Head;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthProbeRequestType value.");
        }
    }
}
