// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Cdn.Models
{
    internal static partial class HealthProbeProtocolExtensions
    {
        public static string ToSerialString(this HealthProbeProtocol value) => value switch
        {
            HealthProbeProtocol.NotSet => "NotSet",
            HealthProbeProtocol.Http => "Http",
            HealthProbeProtocol.Https => "Https",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthProbeProtocol value.")
        };

        public static HealthProbeProtocol ToHealthProbeProtocol(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotSet")) return HealthProbeProtocol.NotSet;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Http")) return HealthProbeProtocol.Http;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Https")) return HealthProbeProtocol.Https;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthProbeProtocol value.");
        }
    }
}
