// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Cdn.Models
{
    internal static partial class GeoFilterActionExtensions
    {
        public static string ToSerialString(this GeoFilterAction value) => value switch
        {
            GeoFilterAction.Block => "Block",
            GeoFilterAction.Allow => "Allow",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown GeoFilterAction value.")
        };

        public static GeoFilterAction ToGeoFilterAction(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Block")) return GeoFilterAction.Block;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Allow")) return GeoFilterAction.Allow;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown GeoFilterAction value.");
        }
    }
}
