// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings. </summary>
    public readonly partial struct FrontDoorQueryStringCachingBehavior : IEquatable<FrontDoorQueryStringCachingBehavior>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorQueryStringCachingBehavior"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorQueryStringCachingBehavior(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IgnoreQueryStringValue = "IgnoreQueryString";
        private const string UseQueryStringValue = "UseQueryString";
        private const string IgnoreSpecifiedQueryStringsValue = "IgnoreSpecifiedQueryStrings";
        private const string IncludeSpecifiedQueryStringsValue = "IncludeSpecifiedQueryStrings";

        /// <summary> IgnoreQueryString. </summary>
        public static FrontDoorQueryStringCachingBehavior IgnoreQueryString { get; } = new FrontDoorQueryStringCachingBehavior(IgnoreQueryStringValue);
        /// <summary> UseQueryString. </summary>
        public static FrontDoorQueryStringCachingBehavior UseQueryString { get; } = new FrontDoorQueryStringCachingBehavior(UseQueryStringValue);
        /// <summary> IgnoreSpecifiedQueryStrings. </summary>
        public static FrontDoorQueryStringCachingBehavior IgnoreSpecifiedQueryStrings { get; } = new FrontDoorQueryStringCachingBehavior(IgnoreSpecifiedQueryStringsValue);
        /// <summary> IncludeSpecifiedQueryStrings. </summary>
        public static FrontDoorQueryStringCachingBehavior IncludeSpecifiedQueryStrings { get; } = new FrontDoorQueryStringCachingBehavior(IncludeSpecifiedQueryStringsValue);
        /// <summary> Determines if two <see cref="FrontDoorQueryStringCachingBehavior"/> values are the same. </summary>
        public static bool operator ==(FrontDoorQueryStringCachingBehavior left, FrontDoorQueryStringCachingBehavior right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorQueryStringCachingBehavior"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorQueryStringCachingBehavior left, FrontDoorQueryStringCachingBehavior right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorQueryStringCachingBehavior"/>. </summary>
        public static implicit operator FrontDoorQueryStringCachingBehavior(string value) => new FrontDoorQueryStringCachingBehavior(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorQueryStringCachingBehavior other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorQueryStringCachingBehavior other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
