// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Supported protocols for the customer's endpoint. </summary>
    public readonly partial struct FrontDoorEndpointProtocol : IEquatable<FrontDoorEndpointProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorEndpointProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorEndpointProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpValue = "Http";
        private const string HttpsValue = "Https";

        /// <summary> Http. </summary>
        public static FrontDoorEndpointProtocol Http { get; } = new FrontDoorEndpointProtocol(HttpValue);
        /// <summary> Https. </summary>
        public static FrontDoorEndpointProtocol Https { get; } = new FrontDoorEndpointProtocol(HttpsValue);
        /// <summary> Determines if two <see cref="FrontDoorEndpointProtocol"/> values are the same. </summary>
        public static bool operator ==(FrontDoorEndpointProtocol left, FrontDoorEndpointProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorEndpointProtocol"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorEndpointProtocol left, FrontDoorEndpointProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorEndpointProtocol"/>. </summary>
        public static implicit operator FrontDoorEndpointProtocol(string value) => new FrontDoorEndpointProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorEndpointProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorEndpointProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
