// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The FrontDoorDeploymentStatus. </summary>
    public readonly partial struct FrontDoorDeploymentStatus : IEquatable<FrontDoorDeploymentStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorDeploymentStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorDeploymentStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotStartedValue = "NotStarted";
        private const string InProgressValue = "InProgress";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";

        /// <summary> NotStarted. </summary>
        public static FrontDoorDeploymentStatus NotStarted { get; } = new FrontDoorDeploymentStatus(NotStartedValue);
        /// <summary> InProgress. </summary>
        public static FrontDoorDeploymentStatus InProgress { get; } = new FrontDoorDeploymentStatus(InProgressValue);
        /// <summary> Succeeded. </summary>
        public static FrontDoorDeploymentStatus Succeeded { get; } = new FrontDoorDeploymentStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static FrontDoorDeploymentStatus Failed { get; } = new FrontDoorDeploymentStatus(FailedValue);
        /// <summary> Determines if two <see cref="FrontDoorDeploymentStatus"/> values are the same. </summary>
        public static bool operator ==(FrontDoorDeploymentStatus left, FrontDoorDeploymentStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorDeploymentStatus"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorDeploymentStatus left, FrontDoorDeploymentStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorDeploymentStatus"/>. </summary>
        public static implicit operator FrontDoorDeploymentStatus(string value) => new FrontDoorDeploymentStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorDeploymentStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorDeploymentStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
