// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The domain JSON object required for domain creation or update. </summary>
    public partial class FrontDoorCustomDomainPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FrontDoorCustomDomainPatch"/>. </summary>
        public FrontDoorCustomDomainPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoorCustomDomainPatch"/>. </summary>
        /// <param name="profileName"> The name of the profile which holds the domain. </param>
        /// <param name="tlsSettings"> The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default. </param>
        /// <param name="dnsZone"> Resource reference to the Azure DNS zone. </param>
        /// <param name="preValidatedCustomDomainResource"> Resource reference to the Azure resource where custom domain ownership was prevalidated. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FrontDoorCustomDomainPatch(string profileName, FrontDoorCustomDomainHttpsContent tlsSettings, WritableSubResource dnsZone, FrontDoorCustomDomainUpdatePropertiesParametersPreValidatedCustomDomainResourceId preValidatedCustomDomainResource, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProfileName = profileName;
            TlsSettings = tlsSettings;
            DnsZone = dnsZone;
            PreValidatedCustomDomainResource = preValidatedCustomDomainResource;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the profile which holds the domain. </summary>
        public string ProfileName { get; }
        /// <summary> The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default. </summary>
        public FrontDoorCustomDomainHttpsContent TlsSettings { get; set; }
        /// <summary> Resource reference to the Azure DNS zone. </summary>
        internal WritableSubResource DnsZone { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier DnsZoneId
        {
            get => DnsZone is null ? default : DnsZone.Id;
            set
            {
                if (DnsZone is null)
                    DnsZone = new WritableSubResource();
                DnsZone.Id = value;
            }
        }

        /// <summary> Resource reference to the Azure resource where custom domain ownership was prevalidated. </summary>
        internal FrontDoorCustomDomainUpdatePropertiesParametersPreValidatedCustomDomainResourceId PreValidatedCustomDomainResource { get; set; }
        /// <summary> Resource ID. </summary>
        public ResourceIdentifier PreValidatedCustomDomainResourceId
        {
            get => PreValidatedCustomDomainResource is null ? default : PreValidatedCustomDomainResource.Id;
            set
            {
                if (PreValidatedCustomDomainResource is null)
                    PreValidatedCustomDomainResource = new FrontDoorCustomDomainUpdatePropertiesParametersPreValidatedCustomDomainResourceId();
                PreValidatedCustomDomainResource.Id = value;
            }
        }
    }
}
