// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Defines the source of the SSL certificate. </summary>
    public readonly partial struct FrontDoorCertificateType : IEquatable<FrontDoorCertificateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorCertificateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorCertificateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CustomerCertificateValue = "CustomerCertificate";
        private const string ManagedCertificateValue = "ManagedCertificate";
        private const string AzureFirstPartyManagedCertificateValue = "AzureFirstPartyManagedCertificate";

        /// <summary> CustomerCertificate. </summary>
        public static FrontDoorCertificateType CustomerCertificate { get; } = new FrontDoorCertificateType(CustomerCertificateValue);
        /// <summary> ManagedCertificate. </summary>
        public static FrontDoorCertificateType ManagedCertificate { get; } = new FrontDoorCertificateType(ManagedCertificateValue);
        /// <summary> AzureFirstPartyManagedCertificate. </summary>
        public static FrontDoorCertificateType AzureFirstPartyManagedCertificate { get; } = new FrontDoorCertificateType(AzureFirstPartyManagedCertificateValue);
        /// <summary> Determines if two <see cref="FrontDoorCertificateType"/> values are the same. </summary>
        public static bool operator ==(FrontDoorCertificateType left, FrontDoorCertificateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorCertificateType"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorCertificateType left, FrontDoorCertificateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorCertificateType"/>. </summary>
        public static implicit operator FrontDoorCertificateType(string value) => new FrontDoorCertificateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorCertificateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorCertificateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
