// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The JSON object that contains the properties to validate a domain. </summary>
    public partial class DomainValidationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DomainValidationProperties"/>. </summary>
        internal DomainValidationProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DomainValidationProperties"/>. </summary>
        /// <param name="validationToken"> Challenge used for DNS TXT record or file based validation. </param>
        /// <param name="expiresOn"> The date time that the token expires. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DomainValidationProperties(string validationToken, DateTimeOffset? expiresOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ValidationToken = validationToken;
            ExpiresOn = expiresOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Challenge used for DNS TXT record or file based validation. </summary>
        public string ValidationToken { get; }
        /// <summary> The date time that the token expires. </summary>
        public DateTimeOffset? ExpiresOn { get; }
    }
}
