// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Indicates the endpoint name reuse scope. The default value is TenantReuse. </summary>
    public readonly partial struct DomainNameLabelScope : IEquatable<DomainNameLabelScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DomainNameLabelScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DomainNameLabelScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TenantReuseValue = "TenantReuse";
        private const string SubscriptionReuseValue = "SubscriptionReuse";
        private const string ResourceGroupReuseValue = "ResourceGroupReuse";
        private const string NoReuseValue = "NoReuse";

        /// <summary> TenantReuse. </summary>
        public static DomainNameLabelScope TenantReuse { get; } = new DomainNameLabelScope(TenantReuseValue);
        /// <summary> SubscriptionReuse. </summary>
        public static DomainNameLabelScope SubscriptionReuse { get; } = new DomainNameLabelScope(SubscriptionReuseValue);
        /// <summary> ResourceGroupReuse. </summary>
        public static DomainNameLabelScope ResourceGroupReuse { get; } = new DomainNameLabelScope(ResourceGroupReuseValue);
        /// <summary> NoReuse. </summary>
        public static DomainNameLabelScope NoReuse { get; } = new DomainNameLabelScope(NoReuseValue);
        /// <summary> Determines if two <see cref="DomainNameLabelScope"/> values are the same. </summary>
        public static bool operator ==(DomainNameLabelScope left, DomainNameLabelScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DomainNameLabelScope"/> values are not the same. </summary>
        public static bool operator !=(DomainNameLabelScope left, DomainNameLabelScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DomainNameLabelScope"/>. </summary>
        public static implicit operator DomainNameLabelScope(string value) => new DomainNameLabelScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DomainNameLabelScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DomainNameLabelScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
