// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Defines the SslProtocol condition for the delivery rule. </summary>
    public partial class DeliveryRuleSslProtocolCondition : DeliveryRuleCondition
    {
        /// <summary> Initializes a new instance of <see cref="DeliveryRuleSslProtocolCondition"/>. </summary>
        /// <param name="properties"> Defines the parameters for the condition. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> is null. </exception>
        public DeliveryRuleSslProtocolCondition(DeliveryRuleSslProtocolMatchCondition properties)
        {
            Argument.AssertNotNull(properties, nameof(properties));

            Properties = properties;
            Name = MatchVariable.SslProtocol;
        }

        /// <summary> Initializes a new instance of <see cref="DeliveryRuleSslProtocolCondition"/>. </summary>
        /// <param name="name"> The name of the condition for the delivery rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> Defines the parameters for the condition. </param>
        internal DeliveryRuleSslProtocolCondition(MatchVariable name, IDictionary<string, BinaryData> serializedAdditionalRawData, DeliveryRuleSslProtocolMatchCondition properties) : base(name, serializedAdditionalRawData)
        {
            Properties = properties;
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="DeliveryRuleSslProtocolCondition"/> for deserialization. </summary>
        internal DeliveryRuleSslProtocolCondition()
        {
        }

        /// <summary> Defines the parameters for the condition. </summary>
        public DeliveryRuleSslProtocolMatchCondition Properties { get; set; }
    }
}
