// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Defines the SocketAddress condition for the delivery rule. </summary>
    public partial class DeliveryRuleSocketAddressCondition : DeliveryRuleCondition
    {
        /// <summary> Initializes a new instance of <see cref="DeliveryRuleSocketAddressCondition"/>. </summary>
        /// <param name="properties"> Defines the parameters for the condition. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> is null. </exception>
        public DeliveryRuleSocketAddressCondition(SocketAddressMatchCondition properties)
        {
            Argument.AssertNotNull(properties, nameof(properties));

            Properties = properties;
            Name = MatchVariable.SocketAddr;
        }

        /// <summary> Initializes a new instance of <see cref="DeliveryRuleSocketAddressCondition"/>. </summary>
        /// <param name="name"> The name of the condition for the delivery rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> Defines the parameters for the condition. </param>
        internal DeliveryRuleSocketAddressCondition(MatchVariable name, IDictionary<string, BinaryData> serializedAdditionalRawData, SocketAddressMatchCondition properties) : base(name, serializedAdditionalRawData)
        {
            Properties = properties;
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="DeliveryRuleSocketAddressCondition"/> for deserialization. </summary>
        internal DeliveryRuleSocketAddressCondition()
        {
        }

        /// <summary> Defines the parameters for the condition. </summary>
        public SocketAddressMatchCondition Properties { get; set; }
    }
}
