// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Defines the RequestUri condition for the delivery rule. </summary>
    public partial class DeliveryRuleRequestUriCondition : DeliveryRuleCondition
    {
        /// <summary> Initializes a new instance of <see cref="DeliveryRuleRequestUriCondition"/>. </summary>
        /// <param name="properties"> Defines the parameters for the condition. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> is null. </exception>
        public DeliveryRuleRequestUriCondition(RequestUriMatchCondition properties)
        {
            Argument.AssertNotNull(properties, nameof(properties));

            Properties = properties;
            Name = MatchVariable.RequestUri;
        }

        /// <summary> Initializes a new instance of <see cref="DeliveryRuleRequestUriCondition"/>. </summary>
        /// <param name="name"> The name of the condition for the delivery rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> Defines the parameters for the condition. </param>
        internal DeliveryRuleRequestUriCondition(MatchVariable name, IDictionary<string, BinaryData> serializedAdditionalRawData, RequestUriMatchCondition properties) : base(name, serializedAdditionalRawData)
        {
            Properties = properties;
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="DeliveryRuleRequestUriCondition"/> for deserialization. </summary>
        internal DeliveryRuleRequestUriCondition()
        {
        }

        /// <summary> Defines the parameters for the condition. </summary>
        public RequestUriMatchCondition Properties { get; set; }
    }
}
