// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Defines the Cookies condition for the delivery rule. </summary>
    public partial class DeliveryRuleCookiesCondition : DeliveryRuleCondition
    {
        /// <summary> Initializes a new instance of <see cref="DeliveryRuleCookiesCondition"/>. </summary>
        /// <param name="properties"> Defines the parameters for the condition. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> is null. </exception>
        public DeliveryRuleCookiesCondition(CookiesMatchCondition properties)
        {
            Argument.AssertNotNull(properties, nameof(properties));

            Properties = properties;
            Name = MatchVariable.Cookies;
        }

        /// <summary> Initializes a new instance of <see cref="DeliveryRuleCookiesCondition"/>. </summary>
        /// <param name="name"> The name of the condition for the delivery rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> Defines the parameters for the condition. </param>
        internal DeliveryRuleCookiesCondition(MatchVariable name, IDictionary<string, BinaryData> serializedAdditionalRawData, CookiesMatchCondition properties) : base(name, serializedAdditionalRawData)
        {
            Properties = properties;
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="DeliveryRuleCookiesCondition"/> for deserialization. </summary>
        internal DeliveryRuleCookiesCondition()
        {
        }

        /// <summary> Defines the parameters for the condition. </summary>
        public CookiesMatchCondition Properties { get; set; }
    }
}
