// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary>
    /// The JSON object that contains the properties to secure a custom domain.
    /// Please note <see cref="CustomDomainHttpsContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="UserManagedHttpsContent"/> and <see cref="CdnManagedHttpsContent"/>.
    /// </summary>
    public abstract partial class CustomDomainHttpsContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CustomDomainHttpsContent"/>. </summary>
        /// <param name="protocolType"> Defines the TLS extension protocol that is used for secure delivery. </param>
        protected CustomDomainHttpsContent(SecureDeliveryProtocolType protocolType)
        {
            ProtocolType = protocolType;
        }

        /// <summary> Initializes a new instance of <see cref="CustomDomainHttpsContent"/>. </summary>
        /// <param name="certificateSource"> Defines the source of the SSL certificate. </param>
        /// <param name="protocolType"> Defines the TLS extension protocol that is used for secure delivery. </param>
        /// <param name="minimumTlsVersion"> TLS protocol version that will be used for Https. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CustomDomainHttpsContent(CertificateSource certificateSource, SecureDeliveryProtocolType protocolType, CdnMinimumTlsVersion? minimumTlsVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CertificateSource = certificateSource;
            ProtocolType = protocolType;
            MinimumTlsVersion = minimumTlsVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CustomDomainHttpsContent"/> for deserialization. </summary>
        internal CustomDomainHttpsContent()
        {
        }

        /// <summary> Defines the source of the SSL certificate. </summary>
        internal CertificateSource CertificateSource { get; set; }
        /// <summary> Defines the TLS extension protocol that is used for secure delivery. </summary>
        public SecureDeliveryProtocolType ProtocolType { get; set; }
        /// <summary> TLS protocol version that will be used for Https. </summary>
        public CdnMinimumTlsVersion? MinimumTlsVersion { get; set; }
    }
}
