// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Describes operator to be matched. </summary>
    public readonly partial struct CookiesOperator : IEquatable<CookiesOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CookiesOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CookiesOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnyValue = "Any";
        private const string EqualValue = "Equal";
        private const string ContainsValue = "Contains";
        private const string BeginsWithValue = "BeginsWith";
        private const string EndsWithValue = "EndsWith";
        private const string LessThanValue = "LessThan";
        private const string LessThanOrEqualValue = "LessThanOrEqual";
        private const string GreaterThanValue = "GreaterThan";
        private const string GreaterThanOrEqualValue = "GreaterThanOrEqual";
        private const string RegExValue = "RegEx";

        /// <summary> Any. </summary>
        public static CookiesOperator Any { get; } = new CookiesOperator(AnyValue);
        /// <summary> Equal. </summary>
        public static CookiesOperator Equal { get; } = new CookiesOperator(EqualValue);
        /// <summary> Contains. </summary>
        public static CookiesOperator Contains { get; } = new CookiesOperator(ContainsValue);
        /// <summary> BeginsWith. </summary>
        public static CookiesOperator BeginsWith { get; } = new CookiesOperator(BeginsWithValue);
        /// <summary> EndsWith. </summary>
        public static CookiesOperator EndsWith { get; } = new CookiesOperator(EndsWithValue);
        /// <summary> LessThan. </summary>
        public static CookiesOperator LessThan { get; } = new CookiesOperator(LessThanValue);
        /// <summary> LessThanOrEqual. </summary>
        public static CookiesOperator LessThanOrEqual { get; } = new CookiesOperator(LessThanOrEqualValue);
        /// <summary> GreaterThan. </summary>
        public static CookiesOperator GreaterThan { get; } = new CookiesOperator(GreaterThanValue);
        /// <summary> GreaterThanOrEqual. </summary>
        public static CookiesOperator GreaterThanOrEqual { get; } = new CookiesOperator(GreaterThanOrEqualValue);
        /// <summary> RegEx. </summary>
        public static CookiesOperator RegEx { get; } = new CookiesOperator(RegExValue);
        /// <summary> Determines if two <see cref="CookiesOperator"/> values are the same. </summary>
        public static bool operator ==(CookiesOperator left, CookiesOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CookiesOperator"/> values are not the same. </summary>
        public static bool operator !=(CookiesOperator left, CookiesOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CookiesOperator"/>. </summary>
        public static implicit operator CookiesOperator(string value) => new CookiesOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CookiesOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CookiesOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
