// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Describes operator to be matched. </summary>
    public readonly partial struct ClientPortOperator : IEquatable<ClientPortOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClientPortOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClientPortOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnyValue = "Any";
        private const string EqualValue = "Equal";
        private const string ContainsValue = "Contains";
        private const string BeginsWithValue = "BeginsWith";
        private const string EndsWithValue = "EndsWith";
        private const string LessThanValue = "LessThan";
        private const string LessThanOrEqualValue = "LessThanOrEqual";
        private const string GreaterThanValue = "GreaterThan";
        private const string GreaterThanOrEqualValue = "GreaterThanOrEqual";
        private const string RegExValue = "RegEx";

        /// <summary> Any. </summary>
        public static ClientPortOperator Any { get; } = new ClientPortOperator(AnyValue);
        /// <summary> Equal. </summary>
        public static ClientPortOperator Equal { get; } = new ClientPortOperator(EqualValue);
        /// <summary> Contains. </summary>
        public static ClientPortOperator Contains { get; } = new ClientPortOperator(ContainsValue);
        /// <summary> BeginsWith. </summary>
        public static ClientPortOperator BeginsWith { get; } = new ClientPortOperator(BeginsWithValue);
        /// <summary> EndsWith. </summary>
        public static ClientPortOperator EndsWith { get; } = new ClientPortOperator(EndsWithValue);
        /// <summary> LessThan. </summary>
        public static ClientPortOperator LessThan { get; } = new ClientPortOperator(LessThanValue);
        /// <summary> LessThanOrEqual. </summary>
        public static ClientPortOperator LessThanOrEqual { get; } = new ClientPortOperator(LessThanOrEqualValue);
        /// <summary> GreaterThan. </summary>
        public static ClientPortOperator GreaterThan { get; } = new ClientPortOperator(GreaterThanValue);
        /// <summary> GreaterThanOrEqual. </summary>
        public static ClientPortOperator GreaterThanOrEqual { get; } = new ClientPortOperator(GreaterThanOrEqualValue);
        /// <summary> RegEx. </summary>
        public static ClientPortOperator RegEx { get; } = new ClientPortOperator(RegExValue);
        /// <summary> Determines if two <see cref="ClientPortOperator"/> values are the same. </summary>
        public static bool operator ==(ClientPortOperator left, ClientPortOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClientPortOperator"/> values are not the same. </summary>
        public static bool operator !=(ClientPortOperator left, ClientPortOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClientPortOperator"/>. </summary>
        public static implicit operator ClientPortOperator(string value) => new ClientPortOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClientPortOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClientPortOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
