// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Describes the action that shall be taken when the certificate is updated in Key Vault. </summary>
    public readonly partial struct CertificateUpdateAction : IEquatable<CertificateUpdateAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CertificateUpdateAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CertificateUpdateAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoActionValue = "NoAction";

        /// <summary> NoAction. </summary>
        public static CertificateUpdateAction NoAction { get; } = new CertificateUpdateAction(NoActionValue);
        /// <summary> Determines if two <see cref="CertificateUpdateAction"/> values are the same. </summary>
        public static bool operator ==(CertificateUpdateAction left, CertificateUpdateAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CertificateUpdateAction"/> values are not the same. </summary>
        public static bool operator !=(CertificateUpdateAction left, CertificateUpdateAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CertificateUpdateAction"/>. </summary>
        public static implicit operator CertificateUpdateAction(string value) => new CertificateUpdateAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CertificateUpdateAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CertificateUpdateAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
