// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Type of certificate used. </summary>
    public readonly partial struct CdnManagedCertificateType : IEquatable<CdnManagedCertificateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CdnManagedCertificateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CdnManagedCertificateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SharedValue = "Shared";
        private const string DedicatedValue = "Dedicated";

        /// <summary> Shared. </summary>
        public static CdnManagedCertificateType Shared { get; } = new CdnManagedCertificateType(SharedValue);
        /// <summary> Dedicated. </summary>
        public static CdnManagedCertificateType Dedicated { get; } = new CdnManagedCertificateType(DedicatedValue);
        /// <summary> Determines if two <see cref="CdnManagedCertificateType"/> values are the same. </summary>
        public static bool operator ==(CdnManagedCertificateType left, CdnManagedCertificateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CdnManagedCertificateType"/> values are not the same. </summary>
        public static bool operator !=(CdnManagedCertificateType left, CdnManagedCertificateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CdnManagedCertificateType"/>. </summary>
        public static implicit operator CdnManagedCertificateType(string value) => new CdnManagedCertificateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CdnManagedCertificateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CdnManagedCertificateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
