// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The level at which the content needs to be cached. </summary>
    public readonly partial struct CdnCacheLevel : IEquatable<CdnCacheLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CdnCacheLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CdnCacheLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllValue = "All";

        /// <summary> All. </summary>
        public static CdnCacheLevel All { get; } = new CdnCacheLevel(AllValue);
        /// <summary> Determines if two <see cref="CdnCacheLevel"/> values are the same. </summary>
        public static bool operator ==(CdnCacheLevel left, CdnCacheLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CdnCacheLevel"/> values are not the same. </summary>
        public static bool operator !=(CdnCacheLevel left, CdnCacheLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CdnCacheLevel"/>. </summary>
        public static implicit operator CdnCacheLevel(string value) => new CdnCacheLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CdnCacheLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CdnCacheLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
