// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Recommended sku for the migration. </summary>
    public readonly partial struct CanMigrateDefaultSku : IEquatable<CanMigrateDefaultSku>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CanMigrateDefaultSku"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CanMigrateDefaultSku(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardAzureFrontDoorValue = "Standard_AzureFrontDoor";
        private const string PremiumAzureFrontDoorValue = "Premium_AzureFrontDoor";

        /// <summary> Standard_AzureFrontDoor. </summary>
        public static CanMigrateDefaultSku StandardAzureFrontDoor { get; } = new CanMigrateDefaultSku(StandardAzureFrontDoorValue);
        /// <summary> Premium_AzureFrontDoor. </summary>
        public static CanMigrateDefaultSku PremiumAzureFrontDoor { get; } = new CanMigrateDefaultSku(PremiumAzureFrontDoorValue);
        /// <summary> Determines if two <see cref="CanMigrateDefaultSku"/> values are the same. </summary>
        public static bool operator ==(CanMigrateDefaultSku left, CanMigrateDefaultSku right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CanMigrateDefaultSku"/> values are not the same. </summary>
        public static bool operator !=(CanMigrateDefaultSku left, CanMigrateDefaultSku right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CanMigrateDefaultSku"/>. </summary>
        public static implicit operator CanMigrateDefaultSku(string value) => new CanMigrateDefaultSku(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CanMigrateDefaultSku other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CanMigrateDefaultSku other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
