// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Request body for CanMigrate operation. </summary>
    public partial class CanMigrateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CanMigrateContent"/>. </summary>
        /// <param name="classicResourceReference"> Resource reference of the classic cdn profile or classic frontdoor that need to be migrated. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classicResourceReference"/> is null. </exception>
        public CanMigrateContent(WritableSubResource classicResourceReference)
        {
            Argument.AssertNotNull(classicResourceReference, nameof(classicResourceReference));

            ClassicResourceReference = classicResourceReference;
        }

        /// <summary> Initializes a new instance of <see cref="CanMigrateContent"/>. </summary>
        /// <param name="classicResourceReference"> Resource reference of the classic cdn profile or classic frontdoor that need to be migrated. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CanMigrateContent(WritableSubResource classicResourceReference, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClassicResourceReference = classicResourceReference;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CanMigrateContent"/> for deserialization. </summary>
        internal CanMigrateContent()
        {
        }

        /// <summary> Resource reference of the classic cdn profile or classic frontdoor that need to be migrated. </summary>
        internal WritableSubResource ClassicResourceReference { get; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier ClassicResourceReferenceId
        {
            get => ClassicResourceReference?.Id;
        }
    }
}
