// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Caching behavior for the requests. </summary>
    public readonly partial struct CacheBehaviorSetting : IEquatable<CacheBehaviorSetting>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CacheBehaviorSetting"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CacheBehaviorSetting(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BypassCacheValue = "BypassCache";
        private const string OverrideValue = "Override";
        private const string SetIfMissingValue = "SetIfMissing";

        /// <summary> BypassCache. </summary>
        public static CacheBehaviorSetting BypassCache { get; } = new CacheBehaviorSetting(BypassCacheValue);
        /// <summary> Override. </summary>
        public static CacheBehaviorSetting Override { get; } = new CacheBehaviorSetting(OverrideValue);
        /// <summary> SetIfMissing. </summary>
        public static CacheBehaviorSetting SetIfMissing { get; } = new CacheBehaviorSetting(SetIfMissingValue);
        /// <summary> Determines if two <see cref="CacheBehaviorSetting"/> values are the same. </summary>
        public static bool operator ==(CacheBehaviorSetting left, CacheBehaviorSetting right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CacheBehaviorSetting"/> values are not the same. </summary>
        public static bool operator !=(CacheBehaviorSetting left, CacheBehaviorSetting right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CacheBehaviorSetting"/>. </summary>
        public static implicit operator CacheBehaviorSetting(string value) => new CacheBehaviorSetting(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CacheBehaviorSetting other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CacheBehaviorSetting other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
