// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Cdn.Models;

namespace Azure.ResourceManager.Cdn
{
    internal class MigrateResultOperationSource : IOperationSource<MigrateResult>
    {
        MigrateResult IOperationSource<MigrateResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return MigrateResult.DeserializeMigrateResult(document.RootElement);
        }

        async ValueTask<MigrateResult> IOperationSource<MigrateResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return MigrateResult.DeserializeMigrateResult(document.RootElement);
        }
    }
}
