// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Cdn
{
    internal class FrontDoorSecurityPolicyOperationSource : IOperationSource<FrontDoorSecurityPolicyResource>
    {
        private readonly ArmClient _client;

        internal FrontDoorSecurityPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        FrontDoorSecurityPolicyResource IOperationSource<FrontDoorSecurityPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = FrontDoorSecurityPolicyData.DeserializeFrontDoorSecurityPolicyData(document.RootElement);
            return new FrontDoorSecurityPolicyResource(_client, data);
        }

        async ValueTask<FrontDoorSecurityPolicyResource> IOperationSource<FrontDoorSecurityPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = FrontDoorSecurityPolicyData.DeserializeFrontDoorSecurityPolicyData(document.RootElement);
            return new FrontDoorSecurityPolicyResource(_client, data);
        }
    }
}
