// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Cdn
{
    internal class FrontDoorSecretOperationSource : IOperationSource<FrontDoorSecretResource>
    {
        private readonly ArmClient _client;

        internal FrontDoorSecretOperationSource(ArmClient client)
        {
            _client = client;
        }

        FrontDoorSecretResource IOperationSource<FrontDoorSecretResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = FrontDoorSecretData.DeserializeFrontDoorSecretData(document.RootElement);
            return new FrontDoorSecretResource(_client, data);
        }

        async ValueTask<FrontDoorSecretResource> IOperationSource<FrontDoorSecretResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = FrontDoorSecretData.DeserializeFrontDoorSecretData(document.RootElement);
            return new FrontDoorSecretResource(_client, data);
        }
    }
}
