// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Cdn
{
    internal class FrontDoorRuleOperationSource : IOperationSource<FrontDoorRuleResource>
    {
        private readonly ArmClient _client;

        internal FrontDoorRuleOperationSource(ArmClient client)
        {
            _client = client;
        }

        FrontDoorRuleResource IOperationSource<FrontDoorRuleResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = FrontDoorRuleData.DeserializeFrontDoorRuleData(document.RootElement);
            return new FrontDoorRuleResource(_client, data);
        }

        async ValueTask<FrontDoorRuleResource> IOperationSource<FrontDoorRuleResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = FrontDoorRuleData.DeserializeFrontDoorRuleData(document.RootElement);
            return new FrontDoorRuleResource(_client, data);
        }
    }
}
