// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Cdn
{
    internal class FrontDoorOriginGroupOperationSource : IOperationSource<FrontDoorOriginGroupResource>
    {
        private readonly ArmClient _client;

        internal FrontDoorOriginGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        FrontDoorOriginGroupResource IOperationSource<FrontDoorOriginGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = FrontDoorOriginGroupData.DeserializeFrontDoorOriginGroupData(document.RootElement);
            return new FrontDoorOriginGroupResource(_client, data);
        }

        async ValueTask<FrontDoorOriginGroupResource> IOperationSource<FrontDoorOriginGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = FrontDoorOriginGroupData.DeserializeFrontDoorOriginGroupData(document.RootElement);
            return new FrontDoorOriginGroupResource(_client, data);
        }
    }
}
