// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Cdn.Models;

namespace Azure.ResourceManager.Cdn
{
    internal class CanMigrateResultOperationSource : IOperationSource<CanMigrateResult>
    {
        CanMigrateResult IOperationSource<CanMigrateResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return CanMigrateResult.DeserializeCanMigrateResult(document.RootElement);
        }

        async ValueTask<CanMigrateResult> IOperationSource<CanMigrateResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return CanMigrateResult.DeserializeCanMigrateResult(document.RootElement);
        }
    }
}
