// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Cdn.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Cdn
{
    public partial class CdnEndpointData : IUtf8JsonSerializable, IJsonModel<CdnEndpointData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CdnEndpointData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CdnEndpointData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnEndpointData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CdnEndpointData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(OriginPath))
            {
                writer.WritePropertyName("originPath"u8);
                writer.WriteStringValue(OriginPath);
            }
            if (Optional.IsCollectionDefined(ContentTypesToCompress))
            {
                writer.WritePropertyName("contentTypesToCompress"u8);
                writer.WriteStartArray();
                foreach (var item in ContentTypesToCompress)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(OriginHostHeader))
            {
                writer.WritePropertyName("originHostHeader"u8);
                writer.WriteStringValue(OriginHostHeader);
            }
            if (Optional.IsDefined(IsCompressionEnabled))
            {
                writer.WritePropertyName("isCompressionEnabled"u8);
                writer.WriteBooleanValue(IsCompressionEnabled.Value);
            }
            if (Optional.IsDefined(IsHttpAllowed))
            {
                writer.WritePropertyName("isHttpAllowed"u8);
                writer.WriteBooleanValue(IsHttpAllowed.Value);
            }
            if (Optional.IsDefined(IsHttpsAllowed))
            {
                writer.WritePropertyName("isHttpsAllowed"u8);
                writer.WriteBooleanValue(IsHttpsAllowed.Value);
            }
            if (Optional.IsDefined(QueryStringCachingBehavior))
            {
                writer.WritePropertyName("queryStringCachingBehavior"u8);
                writer.WriteStringValue(QueryStringCachingBehavior.Value.ToSerialString());
            }
            if (Optional.IsDefined(OptimizationType))
            {
                if (OptimizationType != null)
                {
                    writer.WritePropertyName("optimizationType"u8);
                    writer.WriteStringValue(OptimizationType.Value.ToString());
                }
                else
                {
                    writer.WriteNull("optimizationType");
                }
            }
            if (Optional.IsDefined(ProbePath))
            {
                writer.WritePropertyName("probePath"u8);
                writer.WriteStringValue(ProbePath);
            }
            if (Optional.IsCollectionDefined(GeoFilters))
            {
                writer.WritePropertyName("geoFilters"u8);
                writer.WriteStartArray();
                foreach (var item in GeoFilters)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DefaultOriginGroup))
            {
                if (DefaultOriginGroup != null)
                {
                    writer.WritePropertyName("defaultOriginGroup"u8);
                    writer.WriteObjectValue(DefaultOriginGroup, options);
                }
                else
                {
                    writer.WriteNull("defaultOriginGroup");
                }
            }
            if (Optional.IsCollectionDefined(UriSigningKeys))
            {
                if (UriSigningKeys != null)
                {
                    writer.WritePropertyName("urlSigningKeys"u8);
                    writer.WriteStartArray();
                    foreach (var item in UriSigningKeys)
                    {
                        writer.WriteObjectValue(item, options);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("urlSigningKeys");
                }
            }
            if (Optional.IsDefined(DeliveryPolicy))
            {
                if (DeliveryPolicy != null)
                {
                    writer.WritePropertyName("deliveryPolicy"u8);
                    writer.WriteObjectValue(DeliveryPolicy, options);
                }
                else
                {
                    writer.WriteNull("deliveryPolicy");
                }
            }
            if (Optional.IsDefined(WebApplicationFirewallPolicyLink))
            {
                if (WebApplicationFirewallPolicyLink != null)
                {
                    writer.WritePropertyName("webApplicationFirewallPolicyLink"u8);
                    writer.WriteObjectValue(WebApplicationFirewallPolicyLink, options);
                }
                else
                {
                    writer.WriteNull("webApplicationFirewallPolicyLink");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(HostName))
            {
                writer.WritePropertyName("hostName"u8);
                writer.WriteStringValue(HostName);
            }
            if (Optional.IsCollectionDefined(Origins))
            {
                writer.WritePropertyName("origins"u8);
                writer.WriteStartArray();
                foreach (var item in Origins)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(OriginGroups))
            {
                writer.WritePropertyName("originGroups"u8);
                writer.WriteStartArray();
                foreach (var item in OriginGroups)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(DeepCreatedCustomDomains))
            {
                writer.WritePropertyName("customDomains"u8);
                writer.WriteStartArray();
                foreach (var item in DeepCreatedCustomDomains)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceState))
            {
                writer.WritePropertyName("resourceState"u8);
                writer.WriteStringValue(ResourceState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            writer.WriteEndObject();
        }

        CdnEndpointData IJsonModel<CdnEndpointData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnEndpointData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CdnEndpointData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCdnEndpointData(document.RootElement, options);
        }

        internal static CdnEndpointData DeserializeCdnEndpointData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string originPath = default;
            IList<string> contentTypesToCompress = default;
            string originHostHeader = default;
            bool? isCompressionEnabled = default;
            bool? isHttpAllowed = default;
            bool? isHttpsAllowed = default;
            QueryStringCachingBehavior? queryStringCachingBehavior = default;
            OptimizationType? optimizationType = default;
            string probePath = default;
            IList<GeoFilter> geoFilters = default;
            EndpointPropertiesUpdateParametersDefaultOriginGroup defaultOriginGroup = default;
            IList<UriSigningKey> uriSigningKeys = default;
            EndpointDeliveryPolicy deliveryPolicy = default;
            EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink = default;
            string hostName = default;
            IList<DeepCreatedOrigin> origins = default;
            IList<DeepCreatedOriginGroup> originGroups = default;
            IReadOnlyList<DeepCreatedCustomDomain> customDomains = default;
            EndpointResourceState? resourceState = default;
            CdnEndpointProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("originPath"u8))
                        {
                            originPath = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("contentTypesToCompress"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            contentTypesToCompress = array;
                            continue;
                        }
                        if (property0.NameEquals("originHostHeader"u8))
                        {
                            originHostHeader = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("isCompressionEnabled"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isCompressionEnabled = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("isHttpAllowed"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isHttpAllowed = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("isHttpsAllowed"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isHttpsAllowed = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("queryStringCachingBehavior"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            queryStringCachingBehavior = property0.Value.GetString().ToQueryStringCachingBehavior();
                            continue;
                        }
                        if (property0.NameEquals("optimizationType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                optimizationType = null;
                                continue;
                            }
                            optimizationType = new OptimizationType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("probePath"u8))
                        {
                            probePath = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("geoFilters"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<GeoFilter> array = new List<GeoFilter>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(GeoFilter.DeserializeGeoFilter(item, options));
                            }
                            geoFilters = array;
                            continue;
                        }
                        if (property0.NameEquals("defaultOriginGroup"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                defaultOriginGroup = null;
                                continue;
                            }
                            defaultOriginGroup = EndpointPropertiesUpdateParametersDefaultOriginGroup.DeserializeEndpointPropertiesUpdateParametersDefaultOriginGroup(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("urlSigningKeys"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                uriSigningKeys = null;
                                continue;
                            }
                            List<UriSigningKey> array = new List<UriSigningKey>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(UriSigningKey.DeserializeUriSigningKey(item, options));
                            }
                            uriSigningKeys = array;
                            continue;
                        }
                        if (property0.NameEquals("deliveryPolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                deliveryPolicy = null;
                                continue;
                            }
                            deliveryPolicy = EndpointDeliveryPolicy.DeserializeEndpointDeliveryPolicy(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("webApplicationFirewallPolicyLink"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                webApplicationFirewallPolicyLink = null;
                                continue;
                            }
                            webApplicationFirewallPolicyLink = EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink.DeserializeEndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("hostName"u8))
                        {
                            hostName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("origins"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<DeepCreatedOrigin> array = new List<DeepCreatedOrigin>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(DeepCreatedOrigin.DeserializeDeepCreatedOrigin(item, options));
                            }
                            origins = array;
                            continue;
                        }
                        if (property0.NameEquals("originGroups"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<DeepCreatedOriginGroup> array = new List<DeepCreatedOriginGroup>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(DeepCreatedOriginGroup.DeserializeDeepCreatedOriginGroup(item, options));
                            }
                            originGroups = array;
                            continue;
                        }
                        if (property0.NameEquals("customDomains"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<DeepCreatedCustomDomain> array = new List<DeepCreatedCustomDomain>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(DeepCreatedCustomDomain.DeserializeDeepCreatedCustomDomain(item, options));
                            }
                            customDomains = array;
                            continue;
                        }
                        if (property0.NameEquals("resourceState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resourceState = new EndpointResourceState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new CdnEndpointProvisioningState(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CdnEndpointData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                originPath,
                contentTypesToCompress ?? new ChangeTrackingList<string>(),
                originHostHeader,
                isCompressionEnabled,
                isHttpAllowed,
                isHttpsAllowed,
                queryStringCachingBehavior,
                optimizationType,
                probePath,
                geoFilters ?? new ChangeTrackingList<GeoFilter>(),
                defaultOriginGroup,
                uriSigningKeys ?? new ChangeTrackingList<UriSigningKey>(),
                deliveryPolicy,
                webApplicationFirewallPolicyLink,
                hostName,
                origins ?? new ChangeTrackingList<DeepCreatedOrigin>(),
                originGroups ?? new ChangeTrackingList<DeepCreatedOriginGroup>(),
                customDomains ?? new ChangeTrackingList<DeepCreatedCustomDomain>(),
                resourceState,
                provisioningState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CdnEndpointData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnEndpointData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CdnEndpointData)} does not support writing '{options.Format}' format.");
            }
        }

        CdnEndpointData IPersistableModel<CdnEndpointData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnEndpointData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCdnEndpointData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CdnEndpointData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CdnEndpointData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
