// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Cdn.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Cdn
{
    public partial class CdnCustomDomainData : IUtf8JsonSerializable, IJsonModel<CdnCustomDomainData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CdnCustomDomainData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CdnCustomDomainData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnCustomDomainData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CdnCustomDomainData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(HostName))
            {
                writer.WritePropertyName("hostName"u8);
                writer.WriteStringValue(HostName);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceState))
            {
                writer.WritePropertyName("resourceState"u8);
                writer.WriteStringValue(ResourceState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(CustomHttpsProvisioningState))
            {
                writer.WritePropertyName("customHttpsProvisioningState"u8);
                writer.WriteStringValue(CustomHttpsProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(CustomHttpsAvailabilityState))
            {
                writer.WritePropertyName("customHttpsProvisioningSubstate"u8);
                writer.WriteStringValue(CustomHttpsAvailabilityState.Value.ToString());
            }
            if (Optional.IsDefined(CustomDomainHttpsContent))
            {
                if (CustomDomainHttpsContent != null)
                {
                    writer.WritePropertyName("customHttpsParameters"u8);
                    writer.WriteObjectValue(CustomDomainHttpsContent, options);
                }
                else
                {
                    writer.WriteNull("customHttpsParameters");
                }
            }
            if (Optional.IsDefined(ValidationData))
            {
                writer.WritePropertyName("validationData"u8);
                writer.WriteStringValue(ValidationData);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            writer.WriteEndObject();
        }

        CdnCustomDomainData IJsonModel<CdnCustomDomainData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnCustomDomainData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CdnCustomDomainData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCdnCustomDomainData(document.RootElement, options);
        }

        internal static CdnCustomDomainData DeserializeCdnCustomDomainData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string hostName = default;
            CustomDomainResourceState? resourceState = default;
            CustomHttpsProvisioningState? customHttpsProvisioningState = default;
            CustomHttpsAvailabilityState? customHttpsProvisioningSubstate = default;
            CustomDomainHttpsContent customHttpsParameters = default;
            string validationData = default;
            CustomHttpsProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("hostName"u8))
                        {
                            hostName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resourceState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resourceState = new CustomDomainResourceState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("customHttpsProvisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            customHttpsProvisioningState = new CustomHttpsProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("customHttpsProvisioningSubstate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            customHttpsProvisioningSubstate = new CustomHttpsAvailabilityState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("customHttpsParameters"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                customHttpsParameters = null;
                                continue;
                            }
                            customHttpsParameters = CustomDomainHttpsContent.DeserializeCustomDomainHttpsContent(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("validationData"u8))
                        {
                            validationData = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new CustomHttpsProvisioningState(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CdnCustomDomainData(
                id,
                name,
                type,
                systemData,
                hostName,
                resourceState,
                customHttpsProvisioningState,
                customHttpsProvisioningSubstate,
                customHttpsParameters,
                validationData,
                provisioningState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CdnCustomDomainData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnCustomDomainData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CdnCustomDomainData)} does not support writing '{options.Format}' format.");
            }
        }

        CdnCustomDomainData IPersistableModel<CdnCustomDomainData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnCustomDomainData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCdnCustomDomainData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CdnCustomDomainData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CdnCustomDomainData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
