// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmCdnModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.EndpointNameAvailabilityContent"/>. </summary>
        /// <param name="name"> The resource name to validate. </param>
        /// <param name="resourceType"> The type of the resource whose name is to be validated. </param>
        /// <param name="autoGeneratedDomainNameLabelScope"> Indicates the endpoint name reuse scope. The default value is TenantReuse. </param>
        /// <returns> A new <see cref="Models.EndpointNameAvailabilityContent"/> instance for mocking. </returns>
        public static EndpointNameAvailabilityContent EndpointNameAvailabilityContent(string name = null, CdnResourceType resourceType = default, DomainNameLabelScope? autoGeneratedDomainNameLabelScope = null)
        {
            return new EndpointNameAvailabilityContent(name, resourceType, autoGeneratedDomainNameLabelScope, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EndpointNameAvailabilityResult"/>. </summary>
        /// <param name="nameAvailable"> Indicates whether the name is available. </param>
        /// <param name="availableHostname"> Returns the available hostname generated based on the AutoGeneratedDomainNameLabelScope when the name is available, otherwise it returns empty string. </param>
        /// <param name="reason"> The reason why the name is not available. </param>
        /// <param name="message"> The detailed error message describing why the name is not available. </param>
        /// <returns> A new <see cref="Models.EndpointNameAvailabilityResult"/> instance for mocking. </returns>
        public static EndpointNameAvailabilityResult EndpointNameAvailabilityResult(bool? nameAvailable = null, string availableHostname = null, string reason = null, string message = null)
        {
            return new EndpointNameAvailabilityResult(nameAvailable, availableHostname, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorUsage"/>. </summary>
        /// <param name="id"> Resource identifier. </param>
        /// <param name="unit"> An enum describing the unit of measurement. </param>
        /// <param name="currentValue"> The current value of the usage. </param>
        /// <param name="limit"> The limit of usage. </param>
        /// <param name="name"> The name of the type of usage. </param>
        /// <returns> A new <see cref="Models.FrontDoorUsage"/> instance for mocking. </returns>
        public static FrontDoorUsage FrontDoorUsage(ResourceIdentifier id = null, FrontDoorUsageUnit unit = default, long currentValue = default, long limit = default, FrontDoorUsageResourceName name = null)
        {
            return new FrontDoorUsage(
                id,
                unit,
                currentValue,
                limit,
                name,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorUsageResourceName"/>. </summary>
        /// <param name="value"> A string describing the resource name. </param>
        /// <param name="localizedValue"> A localized string describing the resource name. </param>
        /// <returns> A new <see cref="Models.FrontDoorUsageResourceName"/> instance for mocking. </returns>
        public static FrontDoorUsageResourceName FrontDoorUsageResourceName(string value = null, string localizedValue = null)
        {
            return new FrontDoorUsageResourceName(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CdnNameAvailabilityResult"/>. </summary>
        /// <param name="nameAvailable"> Indicates whether the name is available. </param>
        /// <param name="reason"> The reason why the name is not available. </param>
        /// <param name="message"> The detailed error message describing why the name is not available. </param>
        /// <returns> A new <see cref="Models.CdnNameAvailabilityResult"/> instance for mocking. </returns>
        public static CdnNameAvailabilityResult CdnNameAvailabilityResult(bool? nameAvailable = null, string reason = null, string message = null)
        {
            return new CdnNameAvailabilityResult(nameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateSecretContent"/>. </summary>
        /// <param name="secretType"> The secret type. </param>
        /// <param name="secretSourceId"> Resource reference to the Azure Key Vault secret. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​. </param>
        /// <param name="secretVersion"> Secret version, if customer is using a specific version. </param>
        /// <returns> A new <see cref="Models.ValidateSecretContent"/> instance for mocking. </returns>
        public static ValidateSecretContent ValidateSecretContent(SecretType secretType = default, ResourceIdentifier secretSourceId = null, string secretVersion = null)
        {
            return new ValidateSecretContent(secretType, secretSourceId != null ? ResourceManagerModelFactory.WritableSubResource(secretSourceId) : null, secretVersion, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateSecretResult"/>. </summary>
        /// <param name="status"> The validation status. </param>
        /// <param name="message"> Detailed error message. </param>
        /// <returns> A new <see cref="Models.ValidateSecretResult"/> instance for mocking. </returns>
        public static ValidateSecretResult ValidateSecretResult(ValidationStatus? status = null, string message = null)
        {
            return new ValidateSecretResult(status, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.ProfileData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="skuName"> The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the profile. </param>
        /// <param name="kind"> Kind of the profile. Used by portal to differentiate traditional CDN profile and new AFD profile. </param>
        /// <param name="identity"> Managed service identity (system assigned and/or user assigned identities). </param>
        /// <param name="resourceState"> Resource status of the profile. </param>
        /// <param name="provisioningState"> Provisioning status of the profile. </param>
        /// <param name="extendedProperties"> Key-Value pair representing additional properties for profiles. </param>
        /// <param name="frontDoorId"> The Id of the frontdoor. </param>
        /// <param name="originResponseTimeoutSeconds"> Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns. </param>
        /// <param name="logScrubbing"> Defines rules that scrub sensitive fields in the Azure Front Door profile logs. </param>
        /// <returns> A new <see cref="Cdn.ProfileData"/> instance for mocking. </returns>
        public static ProfileData ProfileData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CdnSkuName? skuName = null, string kind = null, ManagedServiceIdentity identity = null, ProfileResourceState? resourceState = null, ProfileProvisioningState? provisioningState = null, IReadOnlyDictionary<string, string> extendedProperties = null, Guid? frontDoorId = null, int? originResponseTimeoutSeconds = null, ProfileLogScrubbing logScrubbing = null)
        {
            tags ??= new Dictionary<string, string>();
            extendedProperties ??= new Dictionary<string, string>();

            return new ProfileData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                skuName != null ? new CdnSku(skuName, serializedAdditionalRawData: null) : null,
                kind,
                identity,
                resourceState,
                provisioningState,
                extendedProperties,
                frontDoorId,
                originResponseTimeoutSeconds,
                logScrubbing,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.FrontDoorCustomDomainData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="profileName"> The name of the profile which holds the domain. </param>
        /// <param name="tlsSettings"> The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default. </param>
        /// <param name="dnsZoneId"> Resource reference to the Azure DNS zone. </param>
        /// <param name="preValidatedCustomDomainResourceId"> Resource reference to the Azure resource where custom domain ownership was prevalidated. </param>
        /// <param name="provisioningState"> Provisioning status. </param>
        /// <param name="deploymentStatus"></param>
        /// <param name="domainValidationState"> Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. DCV stands for DomainControlValidation. </param>
        /// <param name="hostName"> The host name of the domain. Must be a domain name. </param>
        /// <param name="extendedProperties"> Key-Value pair representing migration properties for domains. </param>
        /// <param name="validationProperties"> Values the customer needs to validate domain ownership. </param>
        /// <returns> A new <see cref="Cdn.FrontDoorCustomDomainData"/> instance for mocking. </returns>
        public static FrontDoorCustomDomainData FrontDoorCustomDomainData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string profileName = null, FrontDoorCustomDomainHttpsContent tlsSettings = null, ResourceIdentifier dnsZoneId = null, ResourceIdentifier preValidatedCustomDomainResourceId = null, FrontDoorProvisioningState? provisioningState = null, FrontDoorDeploymentStatus? deploymentStatus = null, DomainValidationState? domainValidationState = null, string hostName = null, IDictionary<string, string> extendedProperties = null, DomainValidationProperties validationProperties = null)
        {
            extendedProperties ??= new Dictionary<string, string>();

            return new FrontDoorCustomDomainData(
                id,
                name,
                resourceType,
                systemData,
                profileName,
                tlsSettings,
                dnsZoneId != null ? ResourceManagerModelFactory.WritableSubResource(dnsZoneId) : null,
                preValidatedCustomDomainResourceId != null ? new FrontDoorCustomDomainUpdatePropertiesParametersPreValidatedCustomDomainResourceId(preValidatedCustomDomainResourceId, serializedAdditionalRawData: null) : null,
                provisioningState,
                deploymentStatus,
                domainValidationState,
                hostName,
                extendedProperties,
                validationProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DomainValidationProperties"/>. </summary>
        /// <param name="validationToken"> Challenge used for DNS TXT record or file based validation. </param>
        /// <param name="expiresOn"> The date time that the token expires. </param>
        /// <returns> A new <see cref="Models.DomainValidationProperties"/> instance for mocking. </returns>
        public static DomainValidationProperties DomainValidationProperties(string validationToken = null, DateTimeOffset? expiresOn = null)
        {
            return new DomainValidationProperties(validationToken, expiresOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorCustomDomainPatch"/>. </summary>
        /// <param name="profileName"> The name of the profile which holds the domain. </param>
        /// <param name="tlsSettings"> The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default. </param>
        /// <param name="dnsZoneId"> Resource reference to the Azure DNS zone. </param>
        /// <param name="preValidatedCustomDomainResourceId"> Resource reference to the Azure resource where custom domain ownership was prevalidated. </param>
        /// <returns> A new <see cref="Models.FrontDoorCustomDomainPatch"/> instance for mocking. </returns>
        public static FrontDoorCustomDomainPatch FrontDoorCustomDomainPatch(string profileName = null, FrontDoorCustomDomainHttpsContent tlsSettings = null, ResourceIdentifier dnsZoneId = null, ResourceIdentifier preValidatedCustomDomainResourceId = null)
        {
            return new FrontDoorCustomDomainPatch(profileName, tlsSettings, dnsZoneId != null ? ResourceManagerModelFactory.WritableSubResource(dnsZoneId) : null, preValidatedCustomDomainResourceId != null ? new FrontDoorCustomDomainUpdatePropertiesParametersPreValidatedCustomDomainResourceId(preValidatedCustomDomainResourceId, serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.FrontDoorEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="profileName"> The name of the profile which holds the endpoint. </param>
        /// <param name="enabledState"> Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. </param>
        /// <param name="provisioningState"> Provisioning status. </param>
        /// <param name="deploymentStatus"></param>
        /// <param name="hostName"> The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net. </param>
        /// <param name="autoGeneratedDomainNameLabelScope"> Indicates the endpoint name reuse scope. The default value is TenantReuse. </param>
        /// <returns> A new <see cref="Cdn.FrontDoorEndpointData"/> instance for mocking. </returns>
        public static FrontDoorEndpointData FrontDoorEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string profileName = null, EnabledState? enabledState = null, FrontDoorProvisioningState? provisioningState = null, FrontDoorDeploymentStatus? deploymentStatus = null, string hostName = null, DomainNameLabelScope? autoGeneratedDomainNameLabelScope = null)
        {
            tags ??= new Dictionary<string, string>();

            return new FrontDoorEndpointData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                profileName,
                enabledState,
                provisioningState,
                deploymentStatus,
                hostName,
                autoGeneratedDomainNameLabelScope,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorEndpointPatch"/>. </summary>
        /// <param name="tags"> Endpoint tags. </param>
        /// <param name="profileName"> The name of the profile which holds the endpoint. </param>
        /// <param name="enabledState"> Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. </param>
        /// <returns> A new <see cref="Models.FrontDoorEndpointPatch"/> instance for mocking. </returns>
        public static FrontDoorEndpointPatch FrontDoorEndpointPatch(IDictionary<string, string> tags = null, string profileName = null, EnabledState? enabledState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new FrontDoorEndpointPatch(tags, profileName, enabledState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateCustomDomainResult"/>. </summary>
        /// <param name="isCustomDomainValid"> Indicates whether the custom domain is valid or not. </param>
        /// <param name="reason"> The reason why the custom domain is not valid. </param>
        /// <param name="message"> Error message describing why the custom domain is not valid. </param>
        /// <returns> A new <see cref="Models.ValidateCustomDomainResult"/> instance for mocking. </returns>
        public static ValidateCustomDomainResult ValidateCustomDomainResult(bool? isCustomDomainValid = null, string reason = null, string message = null)
        {
            return new ValidateCustomDomainResult(isCustomDomainValid, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.FrontDoorOriginGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="profileName"> The name of the profile which holds the origin group. </param>
        /// <param name="loadBalancingSettings"> Load balancing settings for a backend pool. </param>
        /// <param name="healthProbeSettings"> Health probe settings to the origin that is used to determine the health of the origin. </param>
        /// <param name="trafficRestorationTimeInMinutes"> Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported. </param>
        /// <param name="sessionAffinityState"> Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. </param>
        /// <param name="provisioningState"> Provisioning status. </param>
        /// <param name="deploymentStatus"></param>
        /// <returns> A new <see cref="Cdn.FrontDoorOriginGroupData"/> instance for mocking. </returns>
        public static FrontDoorOriginGroupData FrontDoorOriginGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string profileName = null, LoadBalancingSettings loadBalancingSettings = null, HealthProbeSettings healthProbeSettings = null, int? trafficRestorationTimeInMinutes = null, EnabledState? sessionAffinityState = null, FrontDoorProvisioningState? provisioningState = null, FrontDoorDeploymentStatus? deploymentStatus = null)
        {
            return new FrontDoorOriginGroupData(
                id,
                name,
                resourceType,
                systemData,
                profileName,
                loadBalancingSettings,
                healthProbeSettings,
                trafficRestorationTimeInMinutes,
                sessionAffinityState,
                provisioningState,
                deploymentStatus,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorOriginGroupPatch"/>. </summary>
        /// <param name="profileName"> The name of the profile which holds the origin group. </param>
        /// <param name="loadBalancingSettings"> Load balancing settings for a backend pool. </param>
        /// <param name="healthProbeSettings"> Health probe settings to the origin that is used to determine the health of the origin. </param>
        /// <param name="trafficRestorationTimeInMinutes"> Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported. </param>
        /// <param name="sessionAffinityState"> Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. </param>
        /// <returns> A new <see cref="Models.FrontDoorOriginGroupPatch"/> instance for mocking. </returns>
        public static FrontDoorOriginGroupPatch FrontDoorOriginGroupPatch(string profileName = null, LoadBalancingSettings loadBalancingSettings = null, HealthProbeSettings healthProbeSettings = null, int? trafficRestorationTimeInMinutes = null, EnabledState? sessionAffinityState = null)
        {
            return new FrontDoorOriginGroupPatch(
                profileName,
                loadBalancingSettings,
                healthProbeSettings,
                trafficRestorationTimeInMinutes,
                sessionAffinityState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.FrontDoorOriginData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="originGroupName"> The name of the origin group which contains this origin. </param>
        /// <param name="originId"> Resource reference to the Azure origin resource. </param>
        /// <param name="hostName"> The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint. </param>
        /// <param name="httpPort"> The value of the HTTP port. Must be between 1 and 65535. </param>
        /// <param name="httpsPort"> The value of the HTTPS port. Must be between 1 and 65535. </param>
        /// <param name="originHostHeader"> The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure Front Door origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint. </param>
        /// <param name="priority"> Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5. </param>
        /// <param name="weight"> Weight of the origin in given origin group for load balancing. Must be between 1 and 1000. </param>
        /// <param name="sharedPrivateLinkResource"> The properties of the private link resource for private origin. </param>
        /// <param name="enabledState"> Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. </param>
        /// <param name="enforceCertificateNameCheck"> Whether to enable certificate name check at origin level. </param>
        /// <param name="provisioningState"> Provisioning status. </param>
        /// <param name="deploymentStatus"></param>
        /// <returns> A new <see cref="Cdn.FrontDoorOriginData"/> instance for mocking. </returns>
        public static FrontDoorOriginData FrontDoorOriginData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string originGroupName = null, ResourceIdentifier originId = null, string hostName = null, int? httpPort = null, int? httpsPort = null, string originHostHeader = null, int? priority = null, int? weight = null, SharedPrivateLinkResourceProperties sharedPrivateLinkResource = null, EnabledState? enabledState = null, bool? enforceCertificateNameCheck = null, FrontDoorProvisioningState? provisioningState = null, FrontDoorDeploymentStatus? deploymentStatus = null)
        {
            return new FrontDoorOriginData(
                id,
                name,
                resourceType,
                systemData,
                originGroupName,
                originId != null ? ResourceManagerModelFactory.WritableSubResource(originId) : null,
                hostName,
                httpPort,
                httpsPort,
                originHostHeader,
                priority,
                weight,
                sharedPrivateLinkResource,
                enabledState,
                enforceCertificateNameCheck,
                provisioningState,
                deploymentStatus,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorOriginPatch"/>. </summary>
        /// <param name="originGroupName"> The name of the origin group which contains this origin. </param>
        /// <param name="originId"> Resource reference to the Azure origin resource. </param>
        /// <param name="hostName"> The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint. </param>
        /// <param name="httpPort"> The value of the HTTP port. Must be between 1 and 65535. </param>
        /// <param name="httpsPort"> The value of the HTTPS port. Must be between 1 and 65535. </param>
        /// <param name="originHostHeader"> The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure Front Door origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint. </param>
        /// <param name="priority"> Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5. </param>
        /// <param name="weight"> Weight of the origin in given origin group for load balancing. Must be between 1 and 1000. </param>
        /// <param name="sharedPrivateLinkResource"> The properties of the private link resource for private origin. </param>
        /// <param name="enabledState"> Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. </param>
        /// <param name="enforceCertificateNameCheck"> Whether to enable certificate name check at origin level. </param>
        /// <returns> A new <see cref="Models.FrontDoorOriginPatch"/> instance for mocking. </returns>
        public static FrontDoorOriginPatch FrontDoorOriginPatch(string originGroupName = null, ResourceIdentifier originId = null, string hostName = null, int? httpPort = null, int? httpsPort = null, string originHostHeader = null, int? priority = null, int? weight = null, SharedPrivateLinkResourceProperties sharedPrivateLinkResource = null, EnabledState? enabledState = null, bool? enforceCertificateNameCheck = null)
        {
            return new FrontDoorOriginPatch(
                originGroupName,
                originId != null ? ResourceManagerModelFactory.WritableSubResource(originId) : null,
                hostName,
                httpPort,
                httpsPort,
                originHostHeader,
                priority,
                weight,
                sharedPrivateLinkResource,
                enabledState,
                enforceCertificateNameCheck,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.FrontDoorRouteData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="endpointName"> The name of the endpoint which holds the route. </param>
        /// <param name="customDomains"> Domains referenced by this endpoint. </param>
        /// <param name="originGroupId"> A reference to the origin group. </param>
        /// <param name="originPath"> A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath. </param>
        /// <param name="ruleSets"> rule sets referenced by this endpoint. </param>
        /// <param name="supportedProtocols"> List of supported protocols for this route. </param>
        /// <param name="patternsToMatch"> The route patterns of the rule. </param>
        /// <param name="cacheConfiguration"> The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object. </param>
        /// <param name="forwardingProtocol"> Protocol this rule will use when forwarding traffic to backends. </param>
        /// <param name="linkToDefaultDomain"> whether this route will be linked to the default endpoint domain. </param>
        /// <param name="httpsRedirect"> Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed. </param>
        /// <param name="enabledState"> Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. </param>
        /// <param name="provisioningState"> Provisioning status. </param>
        /// <param name="deploymentStatus"></param>
        /// <returns> A new <see cref="Cdn.FrontDoorRouteData"/> instance for mocking. </returns>
        public static FrontDoorRouteData FrontDoorRouteData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string endpointName = null, IEnumerable<FrontDoorActivatedResourceInfo> customDomains = null, ResourceIdentifier originGroupId = null, string originPath = null, IEnumerable<WritableSubResource> ruleSets = null, IEnumerable<FrontDoorEndpointProtocol> supportedProtocols = null, IEnumerable<string> patternsToMatch = null, FrontDoorRouteCacheConfiguration cacheConfiguration = null, ForwardingProtocol? forwardingProtocol = null, LinkToDefaultDomain? linkToDefaultDomain = null, HttpsRedirect? httpsRedirect = null, EnabledState? enabledState = null, FrontDoorProvisioningState? provisioningState = null, FrontDoorDeploymentStatus? deploymentStatus = null)
        {
            customDomains ??= new List<FrontDoorActivatedResourceInfo>();
            ruleSets ??= new List<WritableSubResource>();
            supportedProtocols ??= new List<FrontDoorEndpointProtocol>();
            patternsToMatch ??= new List<string>();

            return new FrontDoorRouteData(
                id,
                name,
                resourceType,
                systemData,
                endpointName,
                customDomains?.ToList(),
                originGroupId != null ? ResourceManagerModelFactory.WritableSubResource(originGroupId) : null,
                originPath,
                ruleSets?.ToList(),
                supportedProtocols?.ToList(),
                patternsToMatch?.ToList(),
                cacheConfiguration,
                forwardingProtocol,
                linkToDefaultDomain,
                httpsRedirect,
                enabledState,
                provisioningState,
                deploymentStatus,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorActivatedResourceInfo"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="isActive"> Whether the resource is active or inactive. </param>
        /// <returns> A new <see cref="Models.FrontDoorActivatedResourceInfo"/> instance for mocking. </returns>
        public static FrontDoorActivatedResourceInfo FrontDoorActivatedResourceInfo(ResourceIdentifier id = null, bool? isActive = null)
        {
            return new FrontDoorActivatedResourceInfo(id, isActive, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorRoutePatch"/>. </summary>
        /// <param name="endpointName"> The name of the endpoint which holds the route. </param>
        /// <param name="customDomains"> Domains referenced by this endpoint. </param>
        /// <param name="originGroupId"> A reference to the origin group. </param>
        /// <param name="originPath"> A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath. </param>
        /// <param name="ruleSets"> rule sets referenced by this endpoint. </param>
        /// <param name="supportedProtocols"> List of supported protocols for this route. </param>
        /// <param name="patternsToMatch"> The route patterns of the rule. </param>
        /// <param name="cacheConfiguration"> The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object. </param>
        /// <param name="forwardingProtocol"> Protocol this rule will use when forwarding traffic to backends. </param>
        /// <param name="linkToDefaultDomain"> whether this route will be linked to the default endpoint domain. </param>
        /// <param name="httpsRedirect"> Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed. </param>
        /// <param name="enabledState"> Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. </param>
        /// <returns> A new <see cref="Models.FrontDoorRoutePatch"/> instance for mocking. </returns>
        public static FrontDoorRoutePatch FrontDoorRoutePatch(string endpointName = null, IEnumerable<FrontDoorActivatedResourceInfo> customDomains = null, ResourceIdentifier originGroupId = null, string originPath = null, IEnumerable<WritableSubResource> ruleSets = null, IEnumerable<FrontDoorEndpointProtocol> supportedProtocols = null, IEnumerable<string> patternsToMatch = null, FrontDoorRouteCacheConfiguration cacheConfiguration = null, ForwardingProtocol? forwardingProtocol = null, LinkToDefaultDomain? linkToDefaultDomain = null, HttpsRedirect? httpsRedirect = null, EnabledState? enabledState = null)
        {
            customDomains ??= new List<FrontDoorActivatedResourceInfo>();
            ruleSets ??= new List<WritableSubResource>();
            supportedProtocols ??= new List<FrontDoorEndpointProtocol>();
            patternsToMatch ??= new List<string>();

            return new FrontDoorRoutePatch(
                endpointName,
                customDomains?.ToList(),
                originGroupId != null ? ResourceManagerModelFactory.WritableSubResource(originGroupId) : null,
                originPath,
                ruleSets?.ToList(),
                supportedProtocols?.ToList(),
                patternsToMatch?.ToList(),
                cacheConfiguration,
                forwardingProtocol,
                linkToDefaultDomain,
                httpsRedirect,
                enabledState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.FrontDoorRuleSetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Provisioning status. </param>
        /// <param name="deploymentStatus"></param>
        /// <param name="profileName"> The name of the profile which holds the rule set. </param>
        /// <returns> A new <see cref="Cdn.FrontDoorRuleSetData"/> instance for mocking. </returns>
        public static FrontDoorRuleSetData FrontDoorRuleSetData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, FrontDoorProvisioningState? provisioningState = null, FrontDoorDeploymentStatus? deploymentStatus = null, string profileName = null)
        {
            return new FrontDoorRuleSetData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                deploymentStatus,
                profileName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.FrontDoorRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="ruleSetName"> The name of the rule set containing the rule. </param>
        /// <param name="order"> The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied. </param>
        /// <param name="conditions">
        /// A list of conditions that must be matched for the actions to be executed
        /// Please note <see cref="DeliveryRuleCondition"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DeliveryRuleClientPortCondition"/>, <see cref="DeliveryRuleCookiesCondition"/>, <see cref="DeliveryRuleHostNameCondition"/>, <see cref="DeliveryRuleHttpVersionCondition"/>, <see cref="DeliveryRuleIsDeviceCondition"/>, <see cref="DeliveryRulePostArgsCondition"/>, <see cref="DeliveryRuleQueryStringCondition"/>, <see cref="DeliveryRuleRemoteAddressCondition"/>, <see cref="DeliveryRuleRequestBodyCondition"/>, <see cref="DeliveryRuleRequestHeaderCondition"/>, <see cref="DeliveryRuleRequestMethodCondition"/>, <see cref="DeliveryRuleRequestSchemeCondition"/>, <see cref="DeliveryRuleRequestUriCondition"/>, <see cref="DeliveryRuleServerPortCondition"/>, <see cref="DeliveryRuleSocketAddressCondition"/>, <see cref="DeliveryRuleSslProtocolCondition"/>, <see cref="DeliveryRuleUriFileExtensionCondition"/>, <see cref="DeliveryRuleUriFileNameCondition"/> and <see cref="DeliveryRuleUriPathCondition"/>.
        /// </param>
        /// <param name="actions">
        /// A list of actions that are executed when all the conditions of a rule are satisfied.
        /// Please note <see cref="DeliveryRuleAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DeliveryRuleCacheExpirationAction"/>, <see cref="DeliveryRuleCacheKeyQueryStringAction"/>, <see cref="DeliveryRuleRequestHeaderAction"/>, <see cref="DeliveryRuleResponseHeaderAction"/>, <see cref="OriginGroupOverrideAction"/>, <see cref="DeliveryRuleRouteConfigurationOverrideAction"/>, <see cref="UriRedirectAction"/>, <see cref="UriRewriteAction"/> and <see cref="UriSigningAction"/>.
        /// </param>
        /// <param name="matchProcessingBehavior"> If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue. </param>
        /// <param name="provisioningState"> Provisioning status. </param>
        /// <param name="deploymentStatus"></param>
        /// <returns> A new <see cref="Cdn.FrontDoorRuleData"/> instance for mocking. </returns>
        public static FrontDoorRuleData FrontDoorRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string ruleSetName = null, int? order = null, IEnumerable<DeliveryRuleCondition> conditions = null, IEnumerable<DeliveryRuleAction> actions = null, MatchProcessingBehavior? matchProcessingBehavior = null, FrontDoorProvisioningState? provisioningState = null, FrontDoorDeploymentStatus? deploymentStatus = null)
        {
            conditions ??= new List<DeliveryRuleCondition>();
            actions ??= new List<DeliveryRuleAction>();

            return new FrontDoorRuleData(
                id,
                name,
                resourceType,
                systemData,
                ruleSetName,
                order,
                conditions?.ToList(),
                actions?.ToList(),
                matchProcessingBehavior,
                provisioningState,
                deploymentStatus,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorRulePatch"/>. </summary>
        /// <param name="ruleSetName"> The name of the rule set containing the rule. </param>
        /// <param name="order"> The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied. </param>
        /// <param name="conditions">
        /// A list of conditions that must be matched for the actions to be executed
        /// Please note <see cref="DeliveryRuleCondition"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DeliveryRuleClientPortCondition"/>, <see cref="DeliveryRuleCookiesCondition"/>, <see cref="DeliveryRuleHostNameCondition"/>, <see cref="DeliveryRuleHttpVersionCondition"/>, <see cref="DeliveryRuleIsDeviceCondition"/>, <see cref="DeliveryRulePostArgsCondition"/>, <see cref="DeliveryRuleQueryStringCondition"/>, <see cref="DeliveryRuleRemoteAddressCondition"/>, <see cref="DeliveryRuleRequestBodyCondition"/>, <see cref="DeliveryRuleRequestHeaderCondition"/>, <see cref="DeliveryRuleRequestMethodCondition"/>, <see cref="DeliveryRuleRequestSchemeCondition"/>, <see cref="DeliveryRuleRequestUriCondition"/>, <see cref="DeliveryRuleServerPortCondition"/>, <see cref="DeliveryRuleSocketAddressCondition"/>, <see cref="DeliveryRuleSslProtocolCondition"/>, <see cref="DeliveryRuleUriFileExtensionCondition"/>, <see cref="DeliveryRuleUriFileNameCondition"/> and <see cref="DeliveryRuleUriPathCondition"/>.
        /// </param>
        /// <param name="actions">
        /// A list of actions that are executed when all the conditions of a rule are satisfied.
        /// Please note <see cref="DeliveryRuleAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DeliveryRuleCacheExpirationAction"/>, <see cref="DeliveryRuleCacheKeyQueryStringAction"/>, <see cref="DeliveryRuleRequestHeaderAction"/>, <see cref="DeliveryRuleResponseHeaderAction"/>, <see cref="OriginGroupOverrideAction"/>, <see cref="DeliveryRuleRouteConfigurationOverrideAction"/>, <see cref="UriRedirectAction"/>, <see cref="UriRewriteAction"/> and <see cref="UriSigningAction"/>.
        /// </param>
        /// <param name="matchProcessingBehavior"> If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue. </param>
        /// <returns> A new <see cref="Models.FrontDoorRulePatch"/> instance for mocking. </returns>
        public static FrontDoorRulePatch FrontDoorRulePatch(string ruleSetName = null, int? order = null, IEnumerable<DeliveryRuleCondition> conditions = null, IEnumerable<DeliveryRuleAction> actions = null, MatchProcessingBehavior? matchProcessingBehavior = null)
        {
            conditions ??= new List<DeliveryRuleCondition>();
            actions ??= new List<DeliveryRuleAction>();

            return new FrontDoorRulePatch(
                ruleSetName,
                order,
                conditions?.ToList(),
                actions?.ToList(),
                matchProcessingBehavior,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.FrontDoorSecurityPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Provisioning status. </param>
        /// <param name="deploymentStatus"></param>
        /// <param name="profileName"> The name of the profile which holds the security policy. </param>
        /// <param name="properties">
        /// object which contains security policy parameters
        /// Please note <see cref="SecurityPolicyProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SecurityPolicyWebApplicationFirewall"/>.
        /// </param>
        /// <returns> A new <see cref="Cdn.FrontDoorSecurityPolicyData"/> instance for mocking. </returns>
        public static FrontDoorSecurityPolicyData FrontDoorSecurityPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, FrontDoorProvisioningState? provisioningState = null, FrontDoorDeploymentStatus? deploymentStatus = null, string profileName = null, SecurityPolicyProperties properties = null)
        {
            return new FrontDoorSecurityPolicyData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                deploymentStatus,
                profileName,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.FrontDoorSecretData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Provisioning status. </param>
        /// <param name="deploymentStatus"></param>
        /// <param name="profileName"> The name of the profile which holds the secret. </param>
        /// <param name="properties">
        /// object which contains secret parameters
        /// Please note <see cref="FrontDoorSecretProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AzureFirstPartyManagedCertificateProperties"/>, <see cref="Models.CustomerCertificateProperties"/>, <see cref="Models.ManagedCertificateProperties"/> and <see cref="UriSigningKeyProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Cdn.FrontDoorSecretData"/> instance for mocking. </returns>
        public static FrontDoorSecretData FrontDoorSecretData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, FrontDoorProvisioningState? provisioningState = null, FrontDoorDeploymentStatus? deploymentStatus = null, string profileName = null, FrontDoorSecretProperties properties = null)
        {
            return new FrontDoorSecretData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                deploymentStatus,
                profileName,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetricsResponse"/>. </summary>
        /// <param name="dateTimeBegin"></param>
        /// <param name="dateTimeEnd"></param>
        /// <param name="granularity"></param>
        /// <param name="series"></param>
        /// <returns> A new <see cref="Models.MetricsResponse"/> instance for mocking. </returns>
        public static MetricsResponse MetricsResponse(DateTimeOffset? dateTimeBegin = null, DateTimeOffset? dateTimeEnd = null, MetricsResponseGranularity? granularity = null, IEnumerable<MetricsResponseSeriesItem> series = null)
        {
            series ??= new List<MetricsResponseSeriesItem>();

            return new MetricsResponse(dateTimeBegin, dateTimeEnd, granularity, series?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetricsResponseSeriesItem"/>. </summary>
        /// <param name="metric"></param>
        /// <param name="unit"></param>
        /// <param name="groups"></param>
        /// <param name="data"></param>
        /// <returns> A new <see cref="Models.MetricsResponseSeriesItem"/> instance for mocking. </returns>
        public static MetricsResponseSeriesItem MetricsResponseSeriesItem(string metric = null, MetricsResponseSeriesItemUnit? unit = null, IEnumerable<MetricsResponseSeriesPropertiesItemsItem> groups = null, IEnumerable<Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems> data = null)
        {
            groups ??= new List<MetricsResponseSeriesPropertiesItemsItem>();
            data ??= new List<Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems>();

            return new MetricsResponseSeriesItem(metric, unit, groups?.ToList(), data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetricsResponseSeriesPropertiesItemsItem"/>. </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns> A new <see cref="Models.MetricsResponseSeriesPropertiesItemsItem"/> instance for mocking. </returns>
        public static MetricsResponseSeriesPropertiesItemsItem MetricsResponseSeriesPropertiesItemsItem(string name = null, string value = null)
        {
            return new MetricsResponseSeriesPropertiesItemsItem(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems"/>. </summary>
        /// <param name="dateOn"></param>
        /// <param name="value"></param>
        /// <returns> A new <see cref="Models.Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems"/> instance for mocking. </returns>
        public static Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems(DateTimeOffset? dateOn = null, float? value = null)
        {
            return new Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems(dateOn, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RankingsResponse"/>. </summary>
        /// <param name="dateTimeBegin"></param>
        /// <param name="dateTimeEnd"></param>
        /// <param name="tables"></param>
        /// <returns> A new <see cref="Models.RankingsResponse"/> instance for mocking. </returns>
        public static RankingsResponse RankingsResponse(DateTimeOffset? dateTimeBegin = null, DateTimeOffset? dateTimeEnd = null, IEnumerable<RankingsResponseTablesItem> tables = null)
        {
            tables ??= new List<RankingsResponseTablesItem>();

            return new RankingsResponse(dateTimeBegin, dateTimeEnd, tables?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RankingsResponseTablesItem"/>. </summary>
        /// <param name="ranking"></param>
        /// <param name="data"></param>
        /// <returns> A new <see cref="Models.RankingsResponseTablesItem"/> instance for mocking. </returns>
        public static RankingsResponseTablesItem RankingsResponseTablesItem(string ranking = null, IEnumerable<RankingsResponseTablesPropertiesItemsItem> data = null)
        {
            data ??= new List<RankingsResponseTablesPropertiesItemsItem>();

            return new RankingsResponseTablesItem(ranking, data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RankingsResponseTablesPropertiesItemsItem"/>. </summary>
        /// <param name="name"></param>
        /// <param name="metrics"></param>
        /// <returns> A new <see cref="Models.RankingsResponseTablesPropertiesItemsItem"/> instance for mocking. </returns>
        public static RankingsResponseTablesPropertiesItemsItem RankingsResponseTablesPropertiesItemsItem(string name = null, IEnumerable<RankingsResponseTablesPropertiesItemsMetricsItem> metrics = null)
        {
            metrics ??= new List<RankingsResponseTablesPropertiesItemsMetricsItem>();

            return new RankingsResponseTablesPropertiesItemsItem(name, metrics?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RankingsResponseTablesPropertiesItemsMetricsItem"/>. </summary>
        /// <param name="metric"></param>
        /// <param name="value"></param>
        /// <param name="percentage"></param>
        /// <returns> A new <see cref="Models.RankingsResponseTablesPropertiesItemsMetricsItem"/> instance for mocking. </returns>
        public static RankingsResponseTablesPropertiesItemsMetricsItem RankingsResponseTablesPropertiesItemsMetricsItem(string metric = null, long? value = null, float? percentage = null)
        {
            return new RankingsResponseTablesPropertiesItemsMetricsItem(metric, value, percentage, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContinentsResponse"/>. </summary>
        /// <param name="continents"></param>
        /// <param name="countryOrRegions"></param>
        /// <returns> A new <see cref="Models.ContinentsResponse"/> instance for mocking. </returns>
        public static ContinentsResponse ContinentsResponse(IEnumerable<ContinentsResponseContinentsItem> continents = null, IEnumerable<ContinentsResponseCountryOrRegionsItem> countryOrRegions = null)
        {
            continents ??= new List<ContinentsResponseContinentsItem>();
            countryOrRegions ??= new List<ContinentsResponseCountryOrRegionsItem>();

            return new ContinentsResponse(continents?.ToList(), countryOrRegions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContinentsResponseContinentsItem"/>. </summary>
        /// <param name="id"></param>
        /// <returns> A new <see cref="Models.ContinentsResponseContinentsItem"/> instance for mocking. </returns>
        public static ContinentsResponseContinentsItem ContinentsResponseContinentsItem(string id = null)
        {
            return new ContinentsResponseContinentsItem(id, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContinentsResponseCountryOrRegionsItem"/>. </summary>
        /// <param name="id"></param>
        /// <param name="continentId"></param>
        /// <returns> A new <see cref="Models.ContinentsResponseCountryOrRegionsItem"/> instance for mocking. </returns>
        public static ContinentsResponseCountryOrRegionsItem ContinentsResponseCountryOrRegionsItem(string id = null, string continentId = null)
        {
            return new ContinentsResponseCountryOrRegionsItem(id, continentId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourcesResponse"/>. </summary>
        /// <param name="endpoints"></param>
        /// <param name="customDomains"></param>
        /// <returns> A new <see cref="Models.ResourcesResponse"/> instance for mocking. </returns>
        public static ResourcesResponse ResourcesResponse(IEnumerable<ResourcesResponseEndpointsItem> endpoints = null, IEnumerable<ResourcesResponseCustomDomainsItem> customDomains = null)
        {
            endpoints ??= new List<ResourcesResponseEndpointsItem>();
            customDomains ??= new List<ResourcesResponseCustomDomainsItem>();

            return new ResourcesResponse(endpoints?.ToList(), customDomains?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourcesResponseEndpointsItem"/>. </summary>
        /// <param name="id"></param>
        /// <param name="name"></param>
        /// <param name="history"></param>
        /// <param name="customDomains"></param>
        /// <returns> A new <see cref="Models.ResourcesResponseEndpointsItem"/> instance for mocking. </returns>
        public static ResourcesResponseEndpointsItem ResourcesResponseEndpointsItem(string id = null, string name = null, bool? history = null, IEnumerable<ResourcesResponseEndpointsPropertiesItemsItem> customDomains = null)
        {
            customDomains ??= new List<ResourcesResponseEndpointsPropertiesItemsItem>();

            return new ResourcesResponseEndpointsItem(id, name, history, customDomains?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourcesResponseEndpointsPropertiesItemsItem"/>. </summary>
        /// <param name="id"></param>
        /// <param name="name"></param>
        /// <param name="endpointId"></param>
        /// <param name="history"></param>
        /// <returns> A new <see cref="Models.ResourcesResponseEndpointsPropertiesItemsItem"/> instance for mocking. </returns>
        public static ResourcesResponseEndpointsPropertiesItemsItem ResourcesResponseEndpointsPropertiesItemsItem(string id = null, string name = null, string endpointId = null, bool? history = null)
        {
            return new ResourcesResponseEndpointsPropertiesItemsItem(id, name, endpointId, history, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourcesResponseCustomDomainsItem"/>. </summary>
        /// <param name="id"></param>
        /// <param name="name"></param>
        /// <param name="endpointId"></param>
        /// <param name="history"></param>
        /// <returns> A new <see cref="Models.ResourcesResponseCustomDomainsItem"/> instance for mocking. </returns>
        public static ResourcesResponseCustomDomainsItem ResourcesResponseCustomDomainsItem(string id = null, string name = null, string endpointId = null, bool? history = null)
        {
            return new ResourcesResponseCustomDomainsItem(id, name, endpointId, history, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WafMetricsResponse"/>. </summary>
        /// <param name="dateTimeBegin"></param>
        /// <param name="dateTimeEnd"></param>
        /// <param name="granularity"></param>
        /// <param name="series"></param>
        /// <returns> A new <see cref="Models.WafMetricsResponse"/> instance for mocking. </returns>
        public static WafMetricsResponse WafMetricsResponse(DateTimeOffset? dateTimeBegin = null, DateTimeOffset? dateTimeEnd = null, WafMetricsResponseGranularity? granularity = null, IEnumerable<WafMetricsResponseSeriesItem> series = null)
        {
            series ??= new List<WafMetricsResponseSeriesItem>();

            return new WafMetricsResponse(dateTimeBegin, dateTimeEnd, granularity, series?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WafMetricsResponseSeriesItem"/>. </summary>
        /// <param name="metric"></param>
        /// <param name="unit"></param>
        /// <param name="groups"></param>
        /// <param name="data"></param>
        /// <returns> A new <see cref="Models.WafMetricsResponseSeriesItem"/> instance for mocking. </returns>
        public static WafMetricsResponseSeriesItem WafMetricsResponseSeriesItem(string metric = null, WafMetricsResponseSeriesItemUnit? unit = null, IEnumerable<WafMetricsResponseSeriesPropertiesItemsItem> groups = null, IEnumerable<Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems> data = null)
        {
            groups ??= new List<WafMetricsResponseSeriesPropertiesItemsItem>();
            data ??= new List<Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems>();

            return new WafMetricsResponseSeriesItem(metric, unit, groups?.ToList(), data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WafMetricsResponseSeriesPropertiesItemsItem"/>. </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns> A new <see cref="Models.WafMetricsResponseSeriesPropertiesItemsItem"/> instance for mocking. </returns>
        public static WafMetricsResponseSeriesPropertiesItemsItem WafMetricsResponseSeriesPropertiesItemsItem(string name = null, string value = null)
        {
            return new WafMetricsResponseSeriesPropertiesItemsItem(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems"/>. </summary>
        /// <param name="dateOn"></param>
        /// <param name="value"></param>
        /// <returns> A new <see cref="Models.Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems"/> instance for mocking. </returns>
        public static Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems(DateTimeOffset? dateOn = null, float? value = null)
        {
            return new Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems(dateOn, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WafRankingsResponse"/>. </summary>
        /// <param name="dateTimeBegin"></param>
        /// <param name="dateTimeEnd"></param>
        /// <param name="groups"></param>
        /// <param name="data"></param>
        /// <returns> A new <see cref="Models.WafRankingsResponse"/> instance for mocking. </returns>
        public static WafRankingsResponse WafRankingsResponse(DateTimeOffset? dateTimeBegin = null, DateTimeOffset? dateTimeEnd = null, IEnumerable<string> groups = null, IEnumerable<WafRankingsResponseDataItem> data = null)
        {
            groups ??= new List<string>();
            data ??= new List<WafRankingsResponseDataItem>();

            return new WafRankingsResponse(dateTimeBegin, dateTimeEnd, groups?.ToList(), data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WafRankingsResponseDataItem"/>. </summary>
        /// <param name="groupValues"></param>
        /// <param name="metrics"></param>
        /// <returns> A new <see cref="Models.WafRankingsResponseDataItem"/> instance for mocking. </returns>
        public static WafRankingsResponseDataItem WafRankingsResponseDataItem(IEnumerable<string> groupValues = null, IEnumerable<ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems> metrics = null)
        {
            groupValues ??= new List<string>();
            metrics ??= new List<ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems>();

            return new WafRankingsResponseDataItem(groupValues?.ToList(), metrics?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems"/>. </summary>
        /// <param name="metric"></param>
        /// <param name="value"></param>
        /// <param name="percentage"></param>
        /// <returns> A new <see cref="Models.ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems"/> instance for mocking. </returns>
        public static ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems(string metric = null, long? value = null, double? percentage = null)
        {
            return new ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems(metric, value, percentage, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CanMigrateResult"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="canMigrateResultType"> Resource type. </param>
        /// <param name="canMigrate"> Flag that says if the profile can be migrated. </param>
        /// <param name="defaultSku"> Recommended sku for the migration. </param>
        /// <param name="errors"></param>
        /// <returns> A new <see cref="Models.CanMigrateResult"/> instance for mocking. </returns>
        public static CanMigrateResult CanMigrateResult(string id = null, string canMigrateResultType = null, bool? canMigrate = null, CanMigrateDefaultSku? defaultSku = null, IEnumerable<MigrationErrorType> errors = null)
        {
            errors ??= new List<MigrationErrorType>();

            return new CanMigrateResult(
                id,
                canMigrateResultType,
                canMigrate,
                defaultSku,
                errors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrationErrorType"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="resourceName"> Resource which has the problem. </param>
        /// <param name="errorMessage"> Error message indicating why the operation failed. </param>
        /// <param name="nextSteps"> Describes what needs to be done to fix the problem. </param>
        /// <returns> A new <see cref="Models.MigrationErrorType"/> instance for mocking. </returns>
        public static MigrationErrorType MigrationErrorType(string code = null, string resourceName = null, string errorMessage = null, string nextSteps = null)
        {
            return new MigrationErrorType(code, resourceName, errorMessage, nextSteps, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrationContent"/>. </summary>
        /// <param name="skuName"> Sku for the migration. </param>
        /// <param name="classicResourceReferenceId"> Resource reference of the classic cdn profile or classic frontdoor that need to be migrated. </param>
        /// <param name="profileName"> Name of the new profile that need to be created. </param>
        /// <param name="migrationWebApplicationFirewallMappings"> Waf mapping for the migrated profile. </param>
        /// <returns> A new <see cref="Models.MigrationContent"/> instance for mocking. </returns>
        public static MigrationContent MigrationContent(CdnSkuName? skuName = null, ResourceIdentifier classicResourceReferenceId = null, string profileName = null, IEnumerable<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings = null)
        {
            migrationWebApplicationFirewallMappings ??= new List<MigrationWebApplicationFirewallMapping>();

            return new MigrationContent(skuName != null ? new CdnSku(skuName, serializedAdditionalRawData: null) : null, classicResourceReferenceId != null ? ResourceManagerModelFactory.WritableSubResource(classicResourceReferenceId) : null, profileName, migrationWebApplicationFirewallMappings?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateResult"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="migrateResultType"> Resource type. </param>
        /// <param name="migratedProfileResourceIdId"> Arm resource id of the migrated profile. </param>
        /// <returns> A new <see cref="Models.MigrateResult"/> instance for mocking. </returns>
        public static MigrateResult MigrateResult(string id = null, string migrateResultType = null, ResourceIdentifier migratedProfileResourceIdId = null)
        {
            return new MigrateResult(id, migrateResultType, migratedProfileResourceIdId != null ? ResourceManagerModelFactory.WritableSubResource(migratedProfileResourceIdId) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SsoUri"/>. </summary>
        /// <param name="availableSsoUri"> The URI used to login to the supplemental portal. </param>
        /// <returns> A new <see cref="Models.SsoUri"/> instance for mocking. </returns>
        public static SsoUri SsoUri(Uri availableSsoUri = null)
        {
            return new SsoUri(availableSsoUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SupportedOptimizationTypesListResult"/>. </summary>
        /// <param name="supportedOptimizationTypes"> Supported optimization types for a profile. </param>
        /// <returns> A new <see cref="Models.SupportedOptimizationTypesListResult"/> instance for mocking. </returns>
        public static SupportedOptimizationTypesListResult SupportedOptimizationTypesListResult(IEnumerable<OptimizationType> supportedOptimizationTypes = null)
        {
            supportedOptimizationTypes ??= new List<OptimizationType>();

            return new SupportedOptimizationTypesListResult(supportedOptimizationTypes?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CdnUsage"/>. </summary>
        /// <param name="resourceType"> Resource type for which the usage is provided. </param>
        /// <param name="unit"> Unit of the usage. e.g. count. </param>
        /// <param name="currentValue"> Actual value of usage on the specified resource type. </param>
        /// <param name="limit"> Quota of the specified resource type. </param>
        /// <returns> A new <see cref="Models.CdnUsage"/> instance for mocking. </returns>
        public static CdnUsage CdnUsage(string resourceType = null, CdnUsageUnit? unit = null, int? currentValue = null, int? limit = null)
        {
            return new CdnUsage(resourceType, unit, currentValue, limit, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.CdnEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="originPath"> A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath. </param>
        /// <param name="contentTypesToCompress"> List of content types on which compression applies. The value should be a valid MIME type. </param>
        /// <param name="originHostHeader"> The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses single origin and can be overridden by the same property specified at origin.If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. </param>
        /// <param name="isCompressionEnabled"> Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB. </param>
        /// <param name="isHttpAllowed"> Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed. </param>
        /// <param name="isHttpsAllowed"> Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed. </param>
        /// <param name="queryStringCachingBehavior"> Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL. </param>
        /// <param name="optimizationType"> Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization. </param>
        /// <param name="probePath"> Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path. This property is only relevant when using a single origin. </param>
        /// <param name="geoFilters"> List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/. </param>
        /// <param name="defaultOriginGroupId"> A reference to the origin group. </param>
        /// <param name="uriSigningKeys"> List of keys used to validate the signed URL hashes. </param>
        /// <param name="deliveryPolicy"> A policy that specifies the delivery rules to be used for an endpoint. </param>
        /// <param name="webApplicationFirewallPolicyLinkId"> Defines the Web Application Firewall policy for the endpoint (if applicable). </param>
        /// <param name="hostName"> The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net. </param>
        /// <param name="origins"> The source of the content being delivered via CDN. </param>
        /// <param name="originGroups"> The origin groups comprising of origins that are used for load balancing the traffic based on availability. </param>
        /// <param name="deepCreatedCustomDomains"> The custom domains under the endpoint. </param>
        /// <param name="resourceState"> Resource status of the endpoint. </param>
        /// <param name="provisioningState"> Provisioning status of the endpoint. </param>
        /// <returns> A new <see cref="Cdn.CdnEndpointData"/> instance for mocking. </returns>
        public static CdnEndpointData CdnEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string originPath = null, IEnumerable<string> contentTypesToCompress = null, string originHostHeader = null, bool? isCompressionEnabled = null, bool? isHttpAllowed = null, bool? isHttpsAllowed = null, QueryStringCachingBehavior? queryStringCachingBehavior = null, OptimizationType? optimizationType = null, string probePath = null, IEnumerable<GeoFilter> geoFilters = null, ResourceIdentifier defaultOriginGroupId = null, IEnumerable<UriSigningKey> uriSigningKeys = null, EndpointDeliveryPolicy deliveryPolicy = null, ResourceIdentifier webApplicationFirewallPolicyLinkId = null, string hostName = null, IEnumerable<DeepCreatedOrigin> origins = null, IEnumerable<DeepCreatedOriginGroup> originGroups = null, IEnumerable<DeepCreatedCustomDomain> deepCreatedCustomDomains = null, EndpointResourceState? resourceState = null, CdnEndpointProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            contentTypesToCompress ??= new List<string>();
            geoFilters ??= new List<GeoFilter>();
            uriSigningKeys ??= new List<UriSigningKey>();
            origins ??= new List<DeepCreatedOrigin>();
            originGroups ??= new List<DeepCreatedOriginGroup>();
            deepCreatedCustomDomains ??= new List<DeepCreatedCustomDomain>();

            return new CdnEndpointData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                originPath,
                contentTypesToCompress?.ToList(),
                originHostHeader,
                isCompressionEnabled,
                isHttpAllowed,
                isHttpsAllowed,
                queryStringCachingBehavior,
                optimizationType,
                probePath,
                geoFilters?.ToList(),
                defaultOriginGroupId != null ? new EndpointPropertiesUpdateParametersDefaultOriginGroup(defaultOriginGroupId, serializedAdditionalRawData: null) : null,
                uriSigningKeys?.ToList(),
                deliveryPolicy,
                webApplicationFirewallPolicyLinkId != null ? new EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink(webApplicationFirewallPolicyLinkId, serializedAdditionalRawData: null) : null,
                hostName,
                origins?.ToList(),
                originGroups?.ToList(),
                deepCreatedCustomDomains?.ToList(),
                resourceState,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DeepCreatedOrigin"/>. </summary>
        /// <param name="name"> Origin name which must be unique within the endpoint. </param>
        /// <param name="hostName"> The address of the origin. It can be a domain name, IPv4 address, or IPv6 address. This should be unique across all origins in an endpoint. </param>
        /// <param name="httpPort"> The value of the HTTP port. Must be between 1 and 65535. </param>
        /// <param name="httpsPort"> The value of the HTTPS port. Must be between 1 and 65535. </param>
        /// <param name="originHostHeader"> The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. </param>
        /// <param name="priority"> Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5. </param>
        /// <param name="weight"> Weight of the origin in given origin group for load balancing. Must be between 1 and 1000. </param>
        /// <param name="enabled"> Origin is enabled for load balancing or not. By default, origin is always enabled. </param>
        /// <param name="privateLinkAlias"> The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'. </param>
        /// <param name="privateLinkResourceId"> The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'. </param>
        /// <param name="privateLinkLocation"> The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated. </param>
        /// <param name="privateLinkApprovalMessage"> A custom message to be included in the approval request to connect to the Private Link. </param>
        /// <param name="privateEndpointStatus"> The approval status for the connection to the Private Link. </param>
        /// <returns> A new <see cref="Models.DeepCreatedOrigin"/> instance for mocking. </returns>
        public static DeepCreatedOrigin DeepCreatedOrigin(string name = null, string hostName = null, int? httpPort = null, int? httpsPort = null, string originHostHeader = null, int? priority = null, int? weight = null, bool? enabled = null, string privateLinkAlias = null, ResourceIdentifier privateLinkResourceId = null, string privateLinkLocation = null, string privateLinkApprovalMessage = null, PrivateEndpointStatus? privateEndpointStatus = null)
        {
            return new DeepCreatedOrigin(
                name,
                hostName,
                httpPort,
                httpsPort,
                originHostHeader,
                priority,
                weight,
                enabled,
                privateLinkAlias,
                privateLinkResourceId,
                privateLinkLocation,
                privateLinkApprovalMessage,
                privateEndpointStatus,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DeepCreatedCustomDomain"/>. </summary>
        /// <param name="name"> Custom domain name. </param>
        /// <param name="hostName"> The host name of the custom domain. Must be a domain name. </param>
        /// <param name="validationData"> Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in China. </param>
        /// <returns> A new <see cref="Models.DeepCreatedCustomDomain"/> instance for mocking. </returns>
        public static DeepCreatedCustomDomain DeepCreatedCustomDomain(string name = null, string hostName = null, string validationData = null)
        {
            return new DeepCreatedCustomDomain(name, hostName, validationData, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.CdnOriginData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="hostName"> The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint. </param>
        /// <param name="httpPort"> The value of the HTTP port. Must be between 1 and 65535. </param>
        /// <param name="httpsPort"> The value of the HTTPS port. Must be between 1 and 65535. </param>
        /// <param name="originHostHeader"> The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint. </param>
        /// <param name="priority"> Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5. </param>
        /// <param name="weight"> Weight of the origin in given origin group for load balancing. Must be between 1 and 1000. </param>
        /// <param name="enabled"> Origin is enabled for load balancing or not. </param>
        /// <param name="privateLinkAlias"> The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'. </param>
        /// <param name="privateLinkResourceId"> The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'. </param>
        /// <param name="privateLinkLocation"> The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated. </param>
        /// <param name="privateLinkApprovalMessage"> A custom message to be included in the approval request to connect to the Private Link. </param>
        /// <param name="resourceState"> Resource status of the origin. </param>
        /// <param name="provisioningState"> Provisioning status of the origin. </param>
        /// <param name="privateEndpointStatus"> The approval status for the connection to the Private Link. </param>
        /// <returns> A new <see cref="Cdn.CdnOriginData"/> instance for mocking. </returns>
        public static CdnOriginData CdnOriginData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string hostName = null, int? httpPort = null, int? httpsPort = null, string originHostHeader = null, int? priority = null, int? weight = null, bool? enabled = null, string privateLinkAlias = null, ResourceIdentifier privateLinkResourceId = null, string privateLinkLocation = null, string privateLinkApprovalMessage = null, OriginResourceState? resourceState = null, OriginProvisioningState? provisioningState = null, PrivateEndpointStatus? privateEndpointStatus = null)
        {
            return new CdnOriginData(
                id,
                name,
                resourceType,
                systemData,
                hostName,
                httpPort,
                httpsPort,
                originHostHeader,
                priority,
                weight,
                enabled,
                privateLinkAlias,
                privateLinkResourceId,
                privateLinkLocation,
                privateLinkApprovalMessage,
                resourceState,
                provisioningState,
                privateEndpointStatus,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.CdnOriginGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="healthProbeSettings"> Health probe settings to the origin that is used to determine the health of the origin. </param>
        /// <param name="origins"> The source of the content being delivered via CDN within given origin group. </param>
        /// <param name="trafficRestorationTimeToHealedOrNewEndpointsInMinutes"> Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported. </param>
        /// <param name="responseBasedOriginErrorDetectionSettings"> The JSON object that contains the properties to determine origin health using real requests/responses. This property is currently not supported. </param>
        /// <param name="resourceState"> Resource status of the origin group. </param>
        /// <param name="provisioningState"> Provisioning status of the origin group. </param>
        /// <returns> A new <see cref="Cdn.CdnOriginGroupData"/> instance for mocking. </returns>
        public static CdnOriginGroupData CdnOriginGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, HealthProbeSettings healthProbeSettings = null, IEnumerable<WritableSubResource> origins = null, int? trafficRestorationTimeToHealedOrNewEndpointsInMinutes = null, ResponseBasedOriginErrorDetectionSettings responseBasedOriginErrorDetectionSettings = null, OriginGroupResourceState? resourceState = null, OriginGroupProvisioningState? provisioningState = null)
        {
            origins ??= new List<WritableSubResource>();

            return new CdnOriginGroupData(
                id,
                name,
                resourceType,
                systemData,
                healthProbeSettings,
                origins?.ToList(),
                trafficRestorationTimeToHealedOrNewEndpointsInMinutes,
                responseBasedOriginErrorDetectionSettings,
                resourceState,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.CdnCustomDomainData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="hostName"> The host name of the custom domain. Must be a domain name. </param>
        /// <param name="resourceState"> Resource status of the custom domain. </param>
        /// <param name="customHttpsProvisioningState"> Provisioning status of the custom domain. </param>
        /// <param name="customHttpsAvailabilityState"> Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. </param>
        /// <param name="customDomainHttpsContent">
        /// Certificate parameters for securing custom HTTPS
        /// Please note <see cref="CustomDomainHttpsContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="UserManagedHttpsContent"/> and <see cref="CdnManagedHttpsContent"/>.
        /// </param>
        /// <param name="validationData"> Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in China. </param>
        /// <param name="provisioningState"> Provisioning status of Custom Https of the custom domain. </param>
        /// <returns> A new <see cref="Cdn.CdnCustomDomainData"/> instance for mocking. </returns>
        public static CdnCustomDomainData CdnCustomDomainData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string hostName = null, CustomDomainResourceState? resourceState = null, CustomHttpsProvisioningState? customHttpsProvisioningState = null, CustomHttpsAvailabilityState? customHttpsAvailabilityState = null, CustomDomainHttpsContent customDomainHttpsContent = null, string validationData = null, CustomHttpsProvisioningState? provisioningState = null)
        {
            return new CdnCustomDomainData(
                id,
                name,
                resourceType,
                systemData,
                hostName,
                resourceState,
                customHttpsProvisioningState,
                customHttpsAvailabilityState,
                customDomainHttpsContent,
                validationData,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateProbeResult"/>. </summary>
        /// <param name="isValid"> Indicates whether the probe URL is accepted or not. </param>
        /// <param name="errorCode"> Specifies the error code when the probe url is not accepted. </param>
        /// <param name="message"> The detailed error message describing why the probe URL is not accepted. </param>
        /// <returns> A new <see cref="Models.ValidateProbeResult"/> instance for mocking. </returns>
        public static ValidateProbeResult ValidateProbeResult(bool? isValid = null, string errorCode = null, string message = null)
        {
            return new ValidateProbeResult(isValid, errorCode, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EdgeNode"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="ipAddressGroups"> List of ip address groups. </param>
        /// <returns> A new <see cref="Models.EdgeNode"/> instance for mocking. </returns>
        public static EdgeNode EdgeNode(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IEnumerable<IPAddressGroup> ipAddressGroups = null)
        {
            ipAddressGroups ??= new List<IPAddressGroup>();

            return new EdgeNode(
                id,
                name,
                resourceType,
                systemData,
                ipAddressGroups?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Cdn.CdnWebApplicationFirewallPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> Gets a unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="skuName"> The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy. </param>
        /// <param name="policySettings"> Describes  policySettings for policy. </param>
        /// <param name="rateLimitRules"> Describes rate limit rules inside the policy. </param>
        /// <param name="customRules"> Describes custom rules inside the policy. </param>
        /// <param name="managedRuleSets"> Describes managed rules inside the policy. </param>
        /// <param name="endpointLinks"> Describes Azure CDN endpoints associated with this Web Application Firewall policy. </param>
        /// <param name="extendedProperties"> Key-Value pair representing additional properties for Web Application Firewall policy. </param>
        /// <param name="provisioningState"> Provisioning state of the WebApplicationFirewallPolicy. </param>
        /// <param name="resourceState"> Resource status of the policy. </param>
        /// <returns> A new <see cref="Cdn.CdnWebApplicationFirewallPolicyData"/> instance for mocking. </returns>
        public static CdnWebApplicationFirewallPolicyData CdnWebApplicationFirewallPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, CdnSkuName? skuName = null, WafPolicySettings policySettings = null, IEnumerable<RateLimitRule> rateLimitRules = null, IEnumerable<CustomRule> customRules = null, IEnumerable<WafPolicyManagedRuleSet> managedRuleSets = null, IEnumerable<SubResource> endpointLinks = null, IDictionary<string, string> extendedProperties = null, WebApplicationFirewallPolicyProvisioningState? provisioningState = null, PolicyResourceState? resourceState = null)
        {
            tags ??= new Dictionary<string, string>();
            rateLimitRules ??= new List<RateLimitRule>();
            customRules ??= new List<CustomRule>();
            managedRuleSets ??= new List<WafPolicyManagedRuleSet>();
            endpointLinks ??= new List<SubResource>();
            extendedProperties ??= new Dictionary<string, string>();

            return new CdnWebApplicationFirewallPolicyData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                skuName != null ? new CdnSku(skuName, serializedAdditionalRawData: null) : null,
                policySettings,
                rateLimitRules != null ? new RateLimitRuleList(rateLimitRules?.ToList(), serializedAdditionalRawData: null) : null,
                customRules != null ? new CustomRuleList(customRules?.ToList(), serializedAdditionalRawData: null) : null,
                managedRuleSets != null ? new ManagedRuleSetList(managedRuleSets?.ToList(), serializedAdditionalRawData: null) : null,
                endpointLinks?.ToList(),
                extendedProperties,
                provisioningState,
                resourceState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedRuleSetDefinition"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="skuName"> The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy. </param>
        /// <param name="provisioningState"> Provisioning state of the managed rule set. </param>
        /// <param name="ruleSetType"> Type of the managed rule set. </param>
        /// <param name="ruleSetVersion"> Version of the managed rule set type. </param>
        /// <param name="ruleGroups"> Rule groups of the managed rule set. </param>
        /// <returns> A new <see cref="Models.ManagedRuleSetDefinition"/> instance for mocking. </returns>
        public static ManagedRuleSetDefinition ManagedRuleSetDefinition(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CdnSkuName? skuName = null, string provisioningState = null, string ruleSetType = null, string ruleSetVersion = null, IEnumerable<ManagedRuleGroupDefinition> ruleGroups = null)
        {
            ruleGroups ??= new List<ManagedRuleGroupDefinition>();

            return new ManagedRuleSetDefinition(
                id,
                name,
                resourceType,
                systemData,
                skuName != null ? new CdnSku(skuName, serializedAdditionalRawData: null) : null,
                provisioningState,
                ruleSetType,
                ruleSetVersion,
                ruleGroups?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedRuleGroupDefinition"/>. </summary>
        /// <param name="ruleGroupName"> Name of the managed rule group. </param>
        /// <param name="description"> Description of the managed rule group. </param>
        /// <param name="rules"> List of rules within the managed rule group. </param>
        /// <returns> A new <see cref="Models.ManagedRuleGroupDefinition"/> instance for mocking. </returns>
        public static ManagedRuleGroupDefinition ManagedRuleGroupDefinition(string ruleGroupName = null, string description = null, IEnumerable<ManagedRuleDefinition> rules = null)
        {
            rules ??= new List<ManagedRuleDefinition>();

            return new ManagedRuleGroupDefinition(ruleGroupName, description, rules?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedRuleDefinition"/>. </summary>
        /// <param name="ruleId"> Identifier for the managed rule. </param>
        /// <param name="description"> Describes the functionality of the managed rule. </param>
        /// <returns> A new <see cref="Models.ManagedRuleDefinition"/> instance for mocking. </returns>
        public static ManagedRuleDefinition ManagedRuleDefinition(string ruleId = null, string description = null)
        {
            return new ManagedRuleDefinition(ruleId, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedCertificateProperties"/>. </summary>
        /// <param name="subject"> Subject name in the certificate. </param>
        /// <param name="expiresOn"> Certificate expiration date. </param>
        /// <returns> A new <see cref="Models.ManagedCertificateProperties"/> instance for mocking. </returns>
        public static ManagedCertificateProperties ManagedCertificateProperties(string subject = null, DateTimeOffset? expiresOn = null)
        {
            return new ManagedCertificateProperties(SecretType.ManagedCertificate, serializedAdditionalRawData: null, subject, expiresOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CustomerCertificateProperties"/>. </summary>
        /// <param name="secretSourceId"> Resource reference to the Azure Key Vault certificate. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​. </param>
        /// <param name="secretVersion"> Version of the secret to be used. </param>
        /// <param name="useLatestVersion"> Whether to use the latest version for the certificate. </param>
        /// <param name="subject"> Subject name in the certificate. </param>
        /// <param name="expiresOn"> Certificate expiration date. </param>
        /// <param name="certificateAuthority"> Certificate issuing authority. </param>
        /// <param name="subjectAlternativeNames"> The list of SANs. </param>
        /// <param name="thumbprint"> Certificate thumbprint. </param>
        /// <returns> A new <see cref="Models.CustomerCertificateProperties"/> instance for mocking. </returns>
        public static CustomerCertificateProperties CustomerCertificateProperties(ResourceIdentifier secretSourceId = null, string secretVersion = null, bool? useLatestVersion = null, string subject = null, DateTimeOffset? expiresOn = null, string certificateAuthority = null, IEnumerable<string> subjectAlternativeNames = null, string thumbprint = null)
        {
            subjectAlternativeNames ??= new List<string>();

            return new CustomerCertificateProperties(
                SecretType.CustomerCertificate,
                serializedAdditionalRawData: null,
                secretSourceId != null ? ResourceManagerModelFactory.WritableSubResource(secretSourceId) : null,
                secretVersion,
                useLatestVersion,
                subject,
                expiresOn,
                certificateAuthority,
                subjectAlternativeNames?.ToList(),
                thumbprint);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureFirstPartyManagedCertificateProperties"/>. </summary>
        /// <param name="secretSourceId"> Resource reference to the Azure Key Vault certificate. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​. </param>
        /// <param name="subject"> Subject name in the certificate. </param>
        /// <param name="expirationDate"> Certificate expiration date. </param>
        /// <param name="certificateAuthority"> Certificate issuing authority. </param>
        /// <param name="subjectAlternativeNames"> The list of SANs. </param>
        /// <param name="thumbprint"> Certificate thumbprint. </param>
        /// <returns> A new <see cref="Models.AzureFirstPartyManagedCertificateProperties"/> instance for mocking. </returns>
        public static AzureFirstPartyManagedCertificateProperties AzureFirstPartyManagedCertificateProperties(ResourceIdentifier secretSourceId = null, string subject = null, string expirationDate = null, string certificateAuthority = null, IEnumerable<string> subjectAlternativeNames = null, string thumbprint = null)
        {
            subjectAlternativeNames ??= new List<string>();

            return new AzureFirstPartyManagedCertificateProperties(
                SecretType.AzureFirstPartyManagedCertificate,
                serializedAdditionalRawData: null,
                secretSourceId != null ? ResourceManagerModelFactory.WritableSubResource(secretSourceId) : null,
                subject,
                expirationDate,
                certificateAuthority,
                subjectAlternativeNames?.ToList(),
                thumbprint);
        }

        /// <summary> Initializes a new instance of FrontDoorCustomDomainData. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="profileName"> The name of the profile which holds the domain. </param>
        /// <param name="tlsSettings"> The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default. </param>
        /// <param name="dnsZoneId"> Resource reference to the Azure DNS zone. </param>
        /// <param name="preValidatedCustomDomainResourceId"> Resource reference to the Azure resource where custom domain ownership was prevalidated. </param>
        /// <param name="provisioningState"> Provisioning status. </param>
        /// <param name="deploymentStatus"></param>
        /// <param name="domainValidationState"> Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. DCV stands for DomainControlValidation. </param>
        /// <param name="hostName"> The host name of the domain. Must be a domain name. </param>
        /// <param name="validationProperties"> Values the customer needs to validate domain ownership. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Cdn.FrontDoorCustomDomainData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static FrontDoorCustomDomainData FrontDoorCustomDomainData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string profileName, FrontDoorCustomDomainHttpsContent tlsSettings, ResourceIdentifier dnsZoneId, ResourceIdentifier preValidatedCustomDomainResourceId, FrontDoorProvisioningState? provisioningState, FrontDoorDeploymentStatus? deploymentStatus, DomainValidationState? domainValidationState, string hostName, DomainValidationProperties validationProperties)
        {
            return FrontDoorCustomDomainData(id: id, name: name, resourceType: resourceType, systemData: systemData, profileName: profileName, tlsSettings: tlsSettings, dnsZoneId: dnsZoneId, preValidatedCustomDomainResourceId: preValidatedCustomDomainResourceId, provisioningState: provisioningState, deploymentStatus: deploymentStatus, domainValidationState: domainValidationState, hostName: hostName, extendedProperties: default, validationProperties: validationProperties);
        }

        /// <summary> Initializes a new instance of ProfileData. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="skuName"> The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the profile. </param>
        /// <param name="kind"> Kind of the profile. Used by portal to differentiate traditional CDN profile and new AFD profile. </param>
        /// <param name="resourceState"> Resource status of the profile. </param>
        /// <param name="provisioningState"> Provisioning status of the profile. </param>
        /// <param name="frontDoorId"> The Id of the frontdoor. </param>
        /// <param name="originResponseTimeoutSeconds"> Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Cdn.ProfileData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static ProfileData ProfileData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, CdnSkuName? skuName, string kind, ProfileResourceState? resourceState, ProfileProvisioningState? provisioningState, Guid? frontDoorId, int? originResponseTimeoutSeconds)
        {
            return ProfileData(id: id, name: name, resourceType: resourceType, systemData: systemData, tags: tags, location: location, skuName: skuName, kind: kind, identity: default, resourceState: resourceState, provisioningState: provisioningState, extendedProperties: default, frontDoorId: frontDoorId, originResponseTimeoutSeconds: originResponseTimeoutSeconds, logScrubbing: default);
        }

        /// <summary> Initializes a new instance of CdnWebApplicationFirewallPolicyData. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> Gets a unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="skuName"> The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy. </param>
        /// <param name="policySettings"> Describes  policySettings for policy. </param>
        /// <param name="rateLimitRules"> Describes rate limit rules inside the policy. </param>
        /// <param name="customRules"> Describes custom rules inside the policy. </param>
        /// <param name="managedRuleSets"> Describes managed rules inside the policy. </param>
        /// <param name="endpointLinks"> Describes Azure CDN endpoints associated with this Web Application Firewall policy. </param>
        /// <param name="provisioningState"> Provisioning state of the WebApplicationFirewallPolicy. </param>
        /// <param name="resourceState"> Resource status of the policy. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Cdn.CdnWebApplicationFirewallPolicyData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static CdnWebApplicationFirewallPolicyData CdnWebApplicationFirewallPolicyData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ETag? etag, CdnSkuName? skuName, WafPolicySettings policySettings, IEnumerable<RateLimitRule> rateLimitRules, IEnumerable<CustomRule> customRules, IEnumerable<WafPolicyManagedRuleSet> managedRuleSets, IEnumerable<SubResource> endpointLinks, WebApplicationFirewallPolicyProvisioningState? provisioningState, PolicyResourceState? resourceState)
        {
            return CdnWebApplicationFirewallPolicyData(id: id, name: name, resourceType: resourceType, systemData: systemData, tags: tags, location: location, etag: etag, skuName: skuName, policySettings: policySettings, rateLimitRules: rateLimitRules, customRules: customRules, managedRuleSets: managedRuleSets, endpointLinks: endpointLinks, extendedProperties: default, provisioningState: provisioningState, resourceState: resourceState);
        }
    }
}
