// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Cdn.Models;

namespace Azure.ResourceManager.Cdn.Samples
{
    public partial class Sample_FrontDoorOriginResource
    {
        // AFDOrigins_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AFDOriginsGet()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/AFDOrigins_Get.json
            // this example is just showing the usage of "FrontDoorOrigins_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorOriginResource created on azure
            // for more information of creating FrontDoorOriginResource, please refer to the document of FrontDoorOriginResource
            string subscriptionId = "subid";
            string resourceGroupName = "RG";
            string profileName = "profile1";
            string originGroupName = "origingroup1";
            string originName = "origin1";
            ResourceIdentifier frontDoorOriginResourceId = FrontDoorOriginResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, profileName, originGroupName, originName);
            FrontDoorOriginResource frontDoorOrigin = client.GetFrontDoorOriginResource(frontDoorOriginResourceId);

            // invoke the operation
            FrontDoorOriginResource result = await frontDoorOrigin.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FrontDoorOriginData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AFDOrigins_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AFDOriginsUpdate()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/AFDOrigins_Update.json
            // this example is just showing the usage of "FrontDoorOrigins_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorOriginResource created on azure
            // for more information of creating FrontDoorOriginResource, please refer to the document of FrontDoorOriginResource
            string subscriptionId = "subid";
            string resourceGroupName = "RG";
            string profileName = "profile1";
            string originGroupName = "origingroup1";
            string originName = "origin1";
            ResourceIdentifier frontDoorOriginResourceId = FrontDoorOriginResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, profileName, originGroupName, originName);
            FrontDoorOriginResource frontDoorOrigin = client.GetFrontDoorOriginResource(frontDoorOriginResourceId);

            // invoke the operation
            FrontDoorOriginPatch patch = new FrontDoorOriginPatch()
            {
                HostName = "host1.blob.core.windows.net",
                HttpPort = 80,
                HttpsPort = 443,
                EnabledState = EnabledState.Enabled,
            };
            ArmOperation<FrontDoorOriginResource> lro = await frontDoorOrigin.UpdateAsync(WaitUntil.Completed, patch);
            FrontDoorOriginResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FrontDoorOriginData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AFDOrigins_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_AFDOriginsDelete()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/AFDOrigins_Delete.json
            // this example is just showing the usage of "FrontDoorOrigins_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorOriginResource created on azure
            // for more information of creating FrontDoorOriginResource, please refer to the document of FrontDoorOriginResource
            string subscriptionId = "subid";
            string resourceGroupName = "RG";
            string profileName = "profile1";
            string originGroupName = "origingroup1";
            string originName = "origin1";
            ResourceIdentifier frontDoorOriginResourceId = FrontDoorOriginResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, profileName, originGroupName, originName);
            FrontDoorOriginResource frontDoorOrigin = client.GetFrontDoorOriginResource(frontDoorOriginResourceId);

            // invoke the operation
            await frontDoorOrigin.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
