// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Cdn.Models;

namespace Azure.ResourceManager.Cdn.Samples
{
    public partial class Sample_CdnWebApplicationFirewallPolicyResource
    {
        // Get Policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetPolicy()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafPolicyGet.json
            // this example is just showing the usage of "Policies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CdnWebApplicationFirewallPolicyResource created on azure
            // for more information of creating CdnWebApplicationFirewallPolicyResource, please refer to the document of CdnWebApplicationFirewallPolicyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string policyName = "MicrosoftCdnWafPolicy";
            ResourceIdentifier cdnWebApplicationFirewallPolicyResourceId = CdnWebApplicationFirewallPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, policyName);
            CdnWebApplicationFirewallPolicyResource cdnWebApplicationFirewallPolicy = client.GetCdnWebApplicationFirewallPolicyResource(cdnWebApplicationFirewallPolicyResourceId);

            // invoke the operation
            CdnWebApplicationFirewallPolicyResource result = await cdnWebApplicationFirewallPolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CdnWebApplicationFirewallPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates specific policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreatesSpecificPolicy()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafPatchPolicy.json
            // this example is just showing the usage of "Policies_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CdnWebApplicationFirewallPolicyResource created on azure
            // for more information of creating CdnWebApplicationFirewallPolicyResource, please refer to the document of CdnWebApplicationFirewallPolicyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string policyName = "MicrosoftCdnWafPolicy";
            ResourceIdentifier cdnWebApplicationFirewallPolicyResourceId = CdnWebApplicationFirewallPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, policyName);
            CdnWebApplicationFirewallPolicyResource cdnWebApplicationFirewallPolicy = client.GetCdnWebApplicationFirewallPolicyResource(cdnWebApplicationFirewallPolicyResourceId);

            // invoke the operation
            CdnWebApplicationFirewallPolicyPatch patch = new CdnWebApplicationFirewallPolicyPatch()
            {
                Tags =
{
["foo"] = "bar",
},
            };
            ArmOperation<CdnWebApplicationFirewallPolicyResource> lro = await cdnWebApplicationFirewallPolicy.UpdateAsync(WaitUntil.Completed, patch);
            CdnWebApplicationFirewallPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CdnWebApplicationFirewallPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete protection policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteProtectionPolicy()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafPolicyDelete.json
            // this example is just showing the usage of "Policies_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CdnWebApplicationFirewallPolicyResource created on azure
            // for more information of creating CdnWebApplicationFirewallPolicyResource, please refer to the document of CdnWebApplicationFirewallPolicyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string policyName = "Policy1";
            ResourceIdentifier cdnWebApplicationFirewallPolicyResourceId = CdnWebApplicationFirewallPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, policyName);
            CdnWebApplicationFirewallPolicyResource cdnWebApplicationFirewallPolicy = client.GetCdnWebApplicationFirewallPolicyResource(cdnWebApplicationFirewallPolicyResourceId);

            // invoke the operation
            await cdnWebApplicationFirewallPolicy.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
