// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Cdn.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Cdn.Samples
{
    public partial class Sample_CdnWebApplicationFirewallPolicyCollection
    {
        // List Policies in a Resource Group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListPoliciesInAResourceGroup()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafListPolicies.json
            // this example is just showing the usage of "Policies_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this CdnWebApplicationFirewallPolicyResource
            CdnWebApplicationFirewallPolicyCollection collection = resourceGroupResource.GetCdnWebApplicationFirewallPolicies();

            // invoke the operation and iterate over the result
            await foreach (CdnWebApplicationFirewallPolicyResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                CdnWebApplicationFirewallPolicyData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get Policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetPolicy()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafPolicyGet.json
            // this example is just showing the usage of "Policies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this CdnWebApplicationFirewallPolicyResource
            CdnWebApplicationFirewallPolicyCollection collection = resourceGroupResource.GetCdnWebApplicationFirewallPolicies();

            // invoke the operation
            string policyName = "MicrosoftCdnWafPolicy";
            CdnWebApplicationFirewallPolicyResource result = await collection.GetAsync(policyName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CdnWebApplicationFirewallPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetPolicy()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafPolicyGet.json
            // this example is just showing the usage of "Policies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this CdnWebApplicationFirewallPolicyResource
            CdnWebApplicationFirewallPolicyCollection collection = resourceGroupResource.GetCdnWebApplicationFirewallPolicies();

            // invoke the operation
            string policyName = "MicrosoftCdnWafPolicy";
            bool result = await collection.ExistsAsync(policyName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetPolicy()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafPolicyGet.json
            // this example is just showing the usage of "Policies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this CdnWebApplicationFirewallPolicyResource
            CdnWebApplicationFirewallPolicyCollection collection = resourceGroupResource.GetCdnWebApplicationFirewallPolicies();

            // invoke the operation
            string policyName = "MicrosoftCdnWafPolicy";
            NullableResponse<CdnWebApplicationFirewallPolicyResource> response = await collection.GetIfExistsAsync(policyName);
            CdnWebApplicationFirewallPolicyResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                CdnWebApplicationFirewallPolicyData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Creates specific policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesSpecificPolicy()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafPolicyCreateOrUpdate.json
            // this example is just showing the usage of "Policies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this CdnWebApplicationFirewallPolicyResource
            CdnWebApplicationFirewallPolicyCollection collection = resourceGroupResource.GetCdnWebApplicationFirewallPolicies();

            // invoke the operation
            string policyName = "MicrosoftCdnWafPolicy";
            CdnWebApplicationFirewallPolicyData data = new CdnWebApplicationFirewallPolicyData(new AzureLocation("WestUs"), new CdnSku()
            {
                Name = CdnSkuName.StandardMicrosoft,
            })
            {
                PolicySettings = new WafPolicySettings()
                {
                    DefaultRedirectUri = new Uri("http://www.bing.com"),
                    DefaultCustomBlockResponseStatusCode = PolicySettingsDefaultCustomBlockResponseStatusCode.TwoHundred,
                    DefaultCustomBlockResponseBody = BinaryData.FromString("\"PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==\""),
                },
                RateLimitRules =
{
new RateLimitRule("RateLimitRule1",1,new CustomRuleMatchCondition[]
{
new CustomRuleMatchCondition(WafMatchVariable.RemoteAddr,MatchOperator.IPMatch,new string[]
{
"192.168.1.0/24","10.0.0.0/24"
})
{
Selector = null,
NegateCondition = false,
Transforms =
{
},
}
},OverrideActionType.Block,1000,0)
{
EnabledState = CustomRuleEnabledState.Enabled,
}
},
                CustomRules =
{
new CustomRule("CustomRule1",2,new CustomRuleMatchCondition[]
{
new CustomRuleMatchCondition(WafMatchVariable.RemoteAddr,MatchOperator.GeoMatch,new string[]
{
"CH"
})
{
Selector = null,
NegateCondition = false,
Transforms =
{
},
},new CustomRuleMatchCondition(WafMatchVariable.RequestHeader,MatchOperator.Contains,new string[]
{
"windows"
})
{
Selector = "UserAgent",
NegateCondition = false,
Transforms =
{
},
},new CustomRuleMatchCondition(WafMatchVariable.QueryString,MatchOperator.Contains,new string[]
{
"<?php","?>"
})
{
Selector = "search",
NegateCondition = false,
Transforms =
{
TransformType.UriDecode,TransformType.Lowercase
},
}
},OverrideActionType.Block)
{
EnabledState = CustomRuleEnabledState.Enabled,
}
},
                ManagedRuleSets =
{
new WafPolicyManagedRuleSet("DefaultRuleSet","preview-1.0")
{
RuleGroupOverrides =
{
new ManagedRuleGroupOverrideSetting("Group1")
{
Rules =
{
new ManagedRuleOverrideSetting("GROUP1-0001")
{
EnabledState = ManagedRuleSetupState.Enabled,
Action = OverrideActionType.Redirect,
},new ManagedRuleOverrideSetting("GROUP1-0002")
{
EnabledState = ManagedRuleSetupState.Disabled,
}
},
}
},
}
},
            };
            ArmOperation<CdnWebApplicationFirewallPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyName, data);
            CdnWebApplicationFirewallPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CdnWebApplicationFirewallPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
