// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Cdn.Models;

namespace Azure.ResourceManager.Cdn.Samples
{
    public partial class Sample_CdnOriginResource
    {
        // Origins_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_OriginsGet()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Origins_Get.json
            // this example is just showing the usage of "CdnOrigins_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CdnOriginResource created on azure
            // for more information of creating CdnOriginResource, please refer to the document of CdnOriginResource
            string subscriptionId = "subid";
            string resourceGroupName = "RG";
            string profileName = "profile1";
            string endpointName = "endpoint1";
            string originName = "www-someDomain-net";
            ResourceIdentifier cdnOriginResourceId = CdnOriginResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, profileName, endpointName, originName);
            CdnOriginResource cdnOrigin = client.GetCdnOriginResource(cdnOriginResourceId);

            // invoke the operation
            CdnOriginResource result = await cdnOrigin.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CdnOriginData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Origins_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_OriginsUpdate()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Origins_Update.json
            // this example is just showing the usage of "CdnOrigins_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CdnOriginResource created on azure
            // for more information of creating CdnOriginResource, please refer to the document of CdnOriginResource
            string subscriptionId = "subid";
            string resourceGroupName = "RG";
            string profileName = "profile1";
            string endpointName = "endpoint1";
            string originName = "www-someDomain-net";
            ResourceIdentifier cdnOriginResourceId = CdnOriginResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, profileName, endpointName, originName);
            CdnOriginResource cdnOrigin = client.GetCdnOriginResource(cdnOriginResourceId);

            // invoke the operation
            CdnOriginPatch patch = new CdnOriginPatch()
            {
                HttpPort = 42,
                HttpsPort = 43,
                OriginHostHeader = "www.someDomain2.net",
                Priority = 1,
                Weight = 50,
                Enabled = true,
                PrivateLinkAlias = "APPSERVER.d84e61f0-0870-4d24-9746-7438fa0019d1.westus2.azure.privatelinkservice",
            };
            ArmOperation<CdnOriginResource> lro = await cdnOrigin.UpdateAsync(WaitUntil.Completed, patch);
            CdnOriginResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CdnOriginData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Origins_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_OriginsDelete()
        {
            // Generated from example definition: specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Origins_Delete.json
            // this example is just showing the usage of "CdnOrigins_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CdnOriginResource created on azure
            // for more information of creating CdnOriginResource, please refer to the document of CdnOriginResource
            string subscriptionId = "subid";
            string resourceGroupName = "RG";
            string profileName = "profile1";
            string endpointName = "endpoint1";
            string originName = "origin1";
            ResourceIdentifier cdnOriginResourceId = CdnOriginResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, profileName, endpointName, originName);
            CdnOriginResource cdnOrigin = client.GetCdnOriginResource(cdnOriginResourceId);

            // invoke the operation
            await cdnOrigin.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
