// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> The parameters to provide for the Web Chat channel. </summary>
    public partial class WebChatChannelProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WebChatChannelProperties"/>. </summary>
        public WebChatChannelProperties()
        {
            Sites = new ChangeTrackingList<WebChatSite>();
        }

        /// <summary> Initializes a new instance of <see cref="WebChatChannelProperties"/>. </summary>
        /// <param name="webChatEmbedCode"> Web chat control embed code. </param>
        /// <param name="sites"> The list of Web Chat sites. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WebChatChannelProperties(string webChatEmbedCode, IList<WebChatSite> sites, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WebChatEmbedCode = webChatEmbedCode;
            Sites = sites;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Web chat control embed code. </summary>
        public string WebChatEmbedCode { get; }
        /// <summary> The list of Web Chat sites. </summary>
        public IList<WebChatSite> Sites { get; }
    }
}
