// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> The parameters to provide for the Direct Line channel. </summary>
    public partial class TelephonyChannelProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TelephonyChannelProperties"/>. </summary>
        public TelephonyChannelProperties()
        {
            PhoneNumbers = new ChangeTrackingList<TelephonyPhoneNumbers>();
            ApiConfigurations = new ChangeTrackingList<TelephonyChannelResourceApiConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="TelephonyChannelProperties"/>. </summary>
        /// <param name="phoneNumbers"> The list of Telephony phone numbers. </param>
        /// <param name="apiConfigurations"> The list of Telephony api configuration. </param>
        /// <param name="cognitiveServiceSubscriptionKey"> The extensionKey1. </param>
        /// <param name="cognitiveServiceRegion"> The extensionKey2. </param>
        /// <param name="defaultLocale"> The default locale of the channel. </param>
        /// <param name="premiumSku"> The premium SKU applied to the channel. </param>
        /// <param name="isEnabled"> Whether the channel is enabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TelephonyChannelProperties(IList<TelephonyPhoneNumbers> phoneNumbers, IList<TelephonyChannelResourceApiConfiguration> apiConfigurations, string cognitiveServiceSubscriptionKey, string cognitiveServiceRegion, string defaultLocale, string premiumSku, bool? isEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PhoneNumbers = phoneNumbers;
            ApiConfigurations = apiConfigurations;
            CognitiveServiceSubscriptionKey = cognitiveServiceSubscriptionKey;
            CognitiveServiceRegion = cognitiveServiceRegion;
            DefaultLocale = defaultLocale;
            PremiumSku = premiumSku;
            IsEnabled = isEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The list of Telephony phone numbers. </summary>
        public IList<TelephonyPhoneNumbers> PhoneNumbers { get; }
        /// <summary> The list of Telephony api configuration. </summary>
        public IList<TelephonyChannelResourceApiConfiguration> ApiConfigurations { get; }
        /// <summary> The extensionKey1. </summary>
        public string CognitiveServiceSubscriptionKey { get; set; }
        /// <summary> The extensionKey2. </summary>
        public string CognitiveServiceRegion { get; set; }
        /// <summary> The default locale of the channel. </summary>
        public string DefaultLocale { get; set; }
        /// <summary> The premium SKU applied to the channel. </summary>
        public string PremiumSku { get; set; }
        /// <summary> Whether the channel is enabled. </summary>
        public bool? IsEnabled { get; set; }
    }
}
