// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> Slack channel definition. </summary>
    public partial class SlackChannel : BotChannelProperties
    {
        /// <summary> Initializes a new instance of <see cref="SlackChannel"/>. </summary>
        public SlackChannel()
        {
            ChannelName = "SlackChannel";
        }

        /// <summary> Initializes a new instance of <see cref="SlackChannel"/>. </summary>
        /// <param name="channelName"> The channel name. </param>
        /// <param name="etag"> Entity Tag of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="location"> Specifies the location of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> The set of properties specific to Slack channel resource. </param>
        internal SlackChannel(string channelName, ETag? etag, string provisioningState, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData, SlackChannelProperties properties) : base(channelName, etag, provisioningState, location, serializedAdditionalRawData)
        {
            Properties = properties;
            ChannelName = channelName ?? "SlackChannel";
        }

        /// <summary> The set of properties specific to Slack channel resource. </summary>
        public SlackChannelProperties Properties { get; set; }
    }
}
