// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> Skype channel definition. </summary>
    public partial class SkypeChannel : BotChannelProperties
    {
        /// <summary> Initializes a new instance of <see cref="SkypeChannel"/>. </summary>
        public SkypeChannel()
        {
            ChannelName = "SkypeChannel";
        }

        /// <summary> Initializes a new instance of <see cref="SkypeChannel"/>. </summary>
        /// <param name="channelName"> The channel name. </param>
        /// <param name="etag"> Entity Tag of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="location"> Specifies the location of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> The set of properties specific to Skype channel resource. </param>
        internal SkypeChannel(string channelName, ETag? etag, string provisioningState, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData, SkypeChannelProperties properties) : base(channelName, etag, provisioningState, location, serializedAdditionalRawData)
        {
            Properties = properties;
            ChannelName = channelName ?? "SkypeChannel";
        }

        /// <summary> The set of properties specific to Skype channel resource. </summary>
        public SkypeChannelProperties Properties { get; set; }
    }
}
