// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> The properties corresponding to a line channel registration. </summary>
    public partial class LineRegistration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LineRegistration"/>. </summary>
        public LineRegistration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LineRegistration"/>. </summary>
        /// <param name="generatedId"> Id generated for the line channel registration. </param>
        /// <param name="channelSecret"> Secret for the line channel registration. </param>
        /// <param name="channelAccessToken"> Access token for the line channel registration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LineRegistration(string generatedId, string channelSecret, string channelAccessToken, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GeneratedId = generatedId;
            ChannelSecret = channelSecret;
            ChannelAccessToken = channelAccessToken;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Id generated for the line channel registration. </summary>
        public string GeneratedId { get; }
        /// <summary> Secret for the line channel registration. </summary>
        public string ChannelSecret { get; set; }
        /// <summary> Access token for the line channel registration. </summary>
        public string ChannelAccessToken { get; set; }
    }
}
