// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> The parameters to provide for the Kik channel. </summary>
    public partial class KikChannelProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KikChannelProperties"/>. </summary>
        /// <param name="userName"> The Kik user name. </param>
        /// <param name="isEnabled"> Whether this channel is enabled for the bot. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="userName"/> is null. </exception>
        public KikChannelProperties(string userName, bool isEnabled)
        {
            Argument.AssertNotNull(userName, nameof(userName));

            UserName = userName;
            IsEnabled = isEnabled;
        }

        /// <summary> Initializes a new instance of <see cref="KikChannelProperties"/>. </summary>
        /// <param name="userName"> The Kik user name. </param>
        /// <param name="apiKey"> Kik API key. Value only returned through POST to the action Channel List API, otherwise empty. </param>
        /// <param name="isValidated"> Whether this channel is validated for the bot. </param>
        /// <param name="isEnabled"> Whether this channel is enabled for the bot. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KikChannelProperties(string userName, string apiKey, bool? isValidated, bool isEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UserName = userName;
            ApiKey = apiKey;
            IsValidated = isValidated;
            IsEnabled = isEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="KikChannelProperties"/> for deserialization. </summary>
        internal KikChannelProperties()
        {
        }

        /// <summary> The Kik user name. </summary>
        public string UserName { get; set; }
        /// <summary> Kik API key. Value only returned through POST to the action Channel List API, otherwise empty. </summary>
        public string ApiKey { get; set; }
        /// <summary> Whether this channel is validated for the bot. </summary>
        public bool? IsValidated { get; set; }
        /// <summary> Whether this channel is enabled for the bot. </summary>
        public bool IsEnabled { get; set; }
    }
}
