// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.BotService.Models
{
    public partial class GetBotServiceQnAMakerEndpointKeyContent : IUtf8JsonSerializable, IJsonModel<GetBotServiceQnAMakerEndpointKeyContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<GetBotServiceQnAMakerEndpointKeyContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<GetBotServiceQnAMakerEndpointKeyContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetBotServiceQnAMakerEndpointKeyContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GetBotServiceQnAMakerEndpointKeyContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Hostname))
            {
                writer.WritePropertyName("hostname"u8);
                writer.WriteStringValue(Hostname);
            }
            if (Optional.IsDefined(Authkey))
            {
                writer.WritePropertyName("authkey"u8);
                writer.WriteStringValue(Authkey);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        GetBotServiceQnAMakerEndpointKeyContent IJsonModel<GetBotServiceQnAMakerEndpointKeyContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetBotServiceQnAMakerEndpointKeyContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GetBotServiceQnAMakerEndpointKeyContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeGetBotServiceQnAMakerEndpointKeyContent(document.RootElement, options);
        }

        internal static GetBotServiceQnAMakerEndpointKeyContent DeserializeGetBotServiceQnAMakerEndpointKeyContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string hostname = default;
            string authkey = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("hostname"u8))
                {
                    hostname = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("authkey"u8))
                {
                    authkey = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new GetBotServiceQnAMakerEndpointKeyContent(hostname, authkey, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<GetBotServiceQnAMakerEndpointKeyContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetBotServiceQnAMakerEndpointKeyContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(GetBotServiceQnAMakerEndpointKeyContent)} does not support writing '{options.Format}' format.");
            }
        }

        GetBotServiceQnAMakerEndpointKeyContent IPersistableModel<GetBotServiceQnAMakerEndpointKeyContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetBotServiceQnAMakerEndpointKeyContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeGetBotServiceQnAMakerEndpointKeyContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(GetBotServiceQnAMakerEndpointKeyContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<GetBotServiceQnAMakerEndpointKeyContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
